# -*- coding: utf-8 -*-

import os
from subprocess import Popen, PIPE

from django.utils.encoding import smart_unicode
from travel.avia.admin.lib.exceptions import SimpleUnicodeException
from travel.avia.admin.lib.fileutils import remove_tmp_dir, get_relative_path


class Un7zipError(SimpleUnicodeException):
    pass


def un7zip(filepath, temporary_dir, log=None):
    remove_tmp_dir(temporary_dir)
    os.makedirs(temporary_dir)

    process = Popen(['7zr', 'x', '-y', '-o%s' % temporary_dir, filepath], stdout=PIPE)
    log_data = process.stdout.read()
    ret_code = process.wait()

    if log:
        log.info(smart_unicode(log_data))

    if ret_code != 0:
        raise Un7zipError(u"Ошибка разархивирования файла")


def get_7zip_filedict(filepath, temporary_dir, log=None):
    un7zip(filepath, temporary_dir, log)

    filedict = {}

    for dirpath, dirnames, filenames in os.walk(temporary_dir):
        for filename in filenames:
            relative = get_relative_path(dirpath, temporary_dir)
            dictname = os.path.join(relative, filename)
            path = os.path.join(dirpath, filename)

            filedict[dictname] = path

    return filedict
