# -*- coding: utf-8 -*-

import logging

from django.utils.translation import ugettext as _, gettext_noop as N_

from travel.avia.admin.lib.exceptions import UnpackError
from travel.avia.admin.lib.unrar import unpack_rar_file
from travel.avia.admin.lib.unzip import unpack_zip_file


log = logging.getLogger(__name__)


UNPACK_METHODS = {
    'zip': unpack_zip_file,
    'rar': unpack_rar_file,
}


def unpack(archive_path, unpack_methods):
    for unpack_method in unpack_methods:
        if unpack_method not in UNPACK_METHODS:
            log.warning(N_(u'Неизвестный метод распаковки %s'), unpack_method)

            continue

        try:
            return UNPACK_METHODS[unpack_method](archive_path)

        except UnpackError:
            pass

    raise UnpackError(_(u'Не смогли распокавать %s, методами %s'),
                      archive_path, u', '.join(unpack_methods))
