# -*- coding: utf-8 -*-

import logging
from datetime import timedelta


log = logging.getLogger(__name__)


def comb_list(delimiter, iterable):
    def _comb_list():
        for j, elem in enumerate(iterable):
            if j:
                yield delimiter
            yield elem
    return list(_comb_list())


def datetime_irange(from_dt, to_dt, delta=None):
    delta = delta or timedelta(minutes=1)
    while from_dt <= to_dt:
        yield from_dt
        from_dt = from_dt + delta
