# coding: utf-8
from __future__ import unicode_literals, print_function, division

from django.conf import settings
from library.python.vault_client.instances import Production as VaultClient

_client = None


def get_client():
    global _client

    if not _client:
        _client = VaultClient(
            authorization='OAuth {}'.format(settings.YAV_OAUTH_TOKEN),
            decode_files=True,
        )

    return _client


def get_secret(secret_id):
    client = get_client()

    return client.get_version(secret_id)['value']


def get_secret_value(secret_id, key):
    return get_secret(secret_id)[key]
