from yql.api.v1.client import YqlClient

YQL_HOST = 'yql.yandex-team.ru'


def get_yql_operation_url(operation):
    return 'https://{}/Operations/{}'.format(YQL_HOST, operation.operation_id)


def build_query_with_parameters(query_template, parameters):
    argument_string = _dump_parameters(parameters)
    return '{}\n{}'.format(argument_string, query_template)


def _dump_parameters(parameters):
    return '\n'.join(
        '${name}={value};'.format(name=name, value=value)
        for name, value in parameters.iteritems()
    )


def log_errors(operation, logger):
    logger.error('Operation %s failed', operation.operation_id)
    if operation.errors:
        for error in operation.errors:
            logger.error(' - %s', error)


class YqlClientFabric(object):
    def create(self):
        # type: () -> YqlClient
        return self._create()

    def _create(self):
        from django.conf import settings
        return YqlClient(token=settings.YQL_TOKEN)
