# -*- coding: utf-8 -*-
import os

from travel.avia.admin.settings import *  # noqa
from travel.avia.admin.settings import (
    EnvironmentSettings,
    INSTANCE_ROLE,
    MEDIA_ROOT,
    MIGRATION_INSTANCE,
    RsyncSource,
    SERVICE_INSTANCE,
    ServiceInstance,
    WorkInstance,
)


YANDEX_ENVIRONMENT_TYPE = os.getenv('YANDEX_ENVIRONMENT_TYPE', 'development')
CURRENT_DC = os.getenv('DEPLOY_NODE_DC')
MYSQL_CLUSTER_ID = os.getenv('AVIA_MYSQL_CLUSTER_ID')
MDB_API_TOKEN = os.getenv('AVIA_MDB_API_TOKEN')

ENABLE_TVM = os.getenv('ENABLE_TVM', 'True') == 'True'
TVM_TOKEN = os.getenv('QLOUD_TVM_TOKEN') or os.getenv('TVM_TOKEN')
TVM_NAME = os.getenv('TVM_NAME')
BLACKBOX_TVM_NAME = 'ProdYateam' if os.getenv('QLOUD_TVM_TOKEN') else 223
EXTERNAL_BLACKBOX_TVM_NAME = os.getenv('EXTERNAL_BLACKBOX_TVM_NAME', 239)
TVM_DESTINATIONS = [BLACKBOX_TVM_NAME, EXTERNAL_BLACKBOX_TVM_NAME]


@EnvironmentSettings.register_config('production')
def configure_production(environment_settings, settings):
    settings['SECRET_KEY'] = os.getenv('AVIA_ADMIN_SECRET_KEY')

    settings['YANDEX_TEAM_BLACKBOX_URL'] = 'http://blackbox.yandex-team.ru/blackbox'
    settings['AVIA_BACK_URL'] = 'http://backend.production.avia.yandex.net'
    settings['YANDEX_BLACKBOX_URL'] = 'http://blackbox.yandex.net/blackbox'
    settings['RAVEN_CONFIG'] = {
        'dsn': os.getenv('SENTRY_DSN'),
    }
    settings['REST_HOST'] = 'int-api.rasp.yandex.net'
    settings['RASPADMIN_HOST'] = 'production.service.admin.rasp.yandex-team.ru'

    settings['RSYNC_IMPORT_CONFIGS'] = {
        'rasp-media-data': [
            RsyncSource(
                host='rasp.admin.rasp.yandex.ru',
                share='rasp-media-data', exclude=[],
                copy_to=os.path.join(MEDIA_ROOT, 'data')
            ),
        ],
    }

    settings['ENVIRONMENT'] = 'production'

    settings['DIRTY_LANG_URL'] = 'http://reqwizard.yandex.net:8891'

    # !!!!!! Осторожнее с копированием этих настроек
    settings['SEND_MAIL_TO_PARTNERS'] = True
    settings['AGENT_MAIL_LIST'] = ['dpetelin@agent.ru']
    settings['AGENT_FULL_YEAR_IMPORT'] = True

    settings['SYNC_WITH_SERP'] = True
    # ----!!!!!

    settings['BILLING_HOST'] = 'csbi-http-api.yandex.net'

    settings['SEND_CHANGES_REMINDERS'] = True
    settings['REMINDERS_HOST'] = 'reminders-api.yandex.net'

    settings['OLVEN_USER'] = "yandex4"

    # для особо долгих скриптов
    settings['MYSQL_CONNECT_TIMEOUT'] = settings['MYSQL_READ_TIMEOUT'] = settings['MYSQL_WRITE_TIMEOUT'] = 3600 * 5

    settings['ADMINS'] = (
        ('Chuprakov Sergey', 'schuprakov@yandex-team.ru'),
        ('Novoselov Ilja', 'nullie@yandex-team.ru'),
        ('Zharinov Andrew', 'zharik@yandex-team.ru'),
    )

    settings['MANAGERS'] = (
        ('Dima Kryukov', 'kryukov@yandex-team.ru'),
        ('Chuprakov Sergey', 'schuprakov@yandex-team.ru'),
        ('Zharinov Andrew', 'zharik@yandex-team.ru'),
        ('Alexander Fetisov', 'af1461@yandex-team.ru'),
        ('Igor Gorobets', 'igorobets@yandex-team.ru'),
    )

    settings['ERROR404_RCPNTS'] = (('Rasp 404', 'rasp-404@yandex-team.ru'),)
    settings['TABLO_ERROR_RCPNTS'] = (('Rasp tablo errors', 'rasp-tablo-errors@yandex-team.ru'),)
    settings['PROCESS_RCPNTS'] = (('Avia process', 'avia-process@yandex-team.ru'),)
    settings['DATACHANGE_RCPNTS'] = (('Data mail list', 'rasp-scripts-data@yandex-team.ru'),)
    settings['RASP_FREE_STATIONS_RCPNTS'] = (('Rasp free stations list', 'rasp-free-stations@yandex-team.ru'),)
    settings['UNKNOWN_CODES_RCPNTS'] = (('Unknown Codes list', 'rasp-unknown-codes@yandex-team.ru'),)
    settings['EXPERSS_SUBST_RCPNTS'] = (('Express subst list', 'rasp-experss-subst@yandex-team.ru'),)

    settings['ERRORS_RECIPIENTS'] = ['rasp-errors@yandex-team.ru']

    settings['SUBURBAN_CHANGE_NOTICES_FROM_EMAIL'] = '"Rasp Info" <rasp-info@yandex-team.ru>'

    settings['DOMAIN_NAMES'] = {
        ServiceInstance.code: 'production.service.admin.rasp.yandex-team.ru',
        WorkInstance.code: 'production.work.admin.rasp.yandex-team.ru'
    }

    settings['DOMAIN_NAME'] = settings['DOMAIN_NAMES'][INSTANCE_ROLE.code]

    if MIGRATION_INSTANCE:
        settings['MORDA_LINK'] = 'https://morda-migration.rasp.admin.rasp.yandex.ru'
    elif SERVICE_INSTANCE:
        settings['MORDA_LINK'] = 'https://morda-service.rasp.admin.rasp.yandex.ru'
    else:
        settings['MORDA_LINK'] = 'https://morda.rasp.admin.rasp.yandex.ru'

    settings['YMAPS_KEY'] = os.getenv('YMAPS_KEY')

    settings['MDS_S3_ENDPOINT_URL'] = 'http://s3.mds.yandex.net'

    settings['S3_SYNC_CONFIGS'] = {
        'adwords': [
            ('avia-media/avia/files', os.path.join(MEDIA_ROOT, 'avia', 'files', 'recipes.xml'), []),
            ('avia-media/avia/files', os.path.join(MEDIA_ROOT, 'avia', 'files', 'points.xml'), []),
        ],
        'adwords_ru': [
            ('avia-media/avia/files', os.path.join(MEDIA_ROOT, 'avia', 'files', 'adwords_1250_3000_landing.xml'), []),
            ('avia-media/avia/files', os.path.join(MEDIA_ROOT, 'avia', 'files', 'adwords_1250_3000.xml'), []),
            ('avia-media/avia/files', os.path.join(MEDIA_ROOT, 'avia', 'files', 'adwords_head_landing.xml'), []),
            ('avia-media/avia/files', os.path.join(MEDIA_ROOT, 'avia', 'files', 'adwords_head.xml'), []),
            ('avia-media/avia/files', os.path.join(MEDIA_ROOT, 'avia', 'files', 'adwords_tail_landing.xml'), []),
            ('avia-media/avia/files', os.path.join(MEDIA_ROOT, 'avia', 'files', 'adwords_tail.xml'), []),
        ],
        'adwords_ua': [
            ('avia-media/avia/files', os.path.join(MEDIA_ROOT, 'avia', 'files', 'adwords_1250_3000_landing_ua.xml'), []),
            ('avia-media/avia/files', os.path.join(MEDIA_ROOT, 'avia', 'files', 'adwords_1250_3000_ua.xml'), []),
            ('avia-media/avia/files', os.path.join(MEDIA_ROOT, 'avia', 'files', 'adwords_head_landing_ua.xml'), []),
            ('avia-media/avia/files', os.path.join(MEDIA_ROOT, 'avia', 'files', 'adwords_head_ua.xml'), []),
            ('avia-media/avia/files', os.path.join(MEDIA_ROOT, 'avia', 'files', 'adwords_tail_landing_ua.xml'), []),
            ('avia-media/avia/files', os.path.join(MEDIA_ROOT, 'avia', 'files', 'adwords_tail_ua.xml'), []),
        ],

        'cohorts': [
            ('avia-media/avia', os.path.join(MEDIA_ROOT, 'avia', 'files', 'cohorts'), []),
        ],

        'feeds': [
            ('avia-media/avia', os.path.join(MEDIA_ROOT, 'avia', 'feeds'), []),
        ],
    }

    settings['CLUSTER_CACHE_HOSTS'] = None

    settings['AVIA_PARTNER_FETCH_SUBJECT'] = 'production'
    settings['AVIA_PARTNER_FETCH_MAIL'] = 'avia-partner-fetch-errors@yandex-team.ru'

    settings['AVIA_API_HOST'] = 'https://api.avia.yandex.net'

    settings['AVATAR_READ_URL'] = 'https://avatars.mds.yandex.net'
    settings['AVATAR_WRITE_URL'] = 'http://avatars-int.mds.yandex.net:13000'

    settings['AVIA_STATS_ADMIN_HOST'] = 'stat.avia.yandex-team.ru'
    settings['AVIA_STATS_IMPORT_USER'] = 'avia-admin-robot'
    settings['AVIA_STATS_IMPORT_PASSWORD'] = os.getenv('AVIA_STAT_IMPORT_PASSWORD')

    settings['FLIGHT_STATS_REQUEST_LIMIT'] = 2000
    settings['FLIGHT_STATS_CREATE_ALERT'] = True
    settings['FLIGHT_STATS_ALERT_HANDLER'] = 'https://avia.yandex.ru/flight-stats/alert'

    settings['EMAIL_HOST'] = 'outbound-relay.yandex.net'


@EnvironmentSettings.register_config('testing')
def configure_testing(environment_settings, settings):
    settings['SECRET_KEY'] = os.getenv('AVIA_ADMIN_SECRET_KEY')

    settings['YANDEX_TEAM_BLACKBOX_URL'] = 'http://blackbox.yandex-team.ru/blackbox'
    settings['YANDEX_BLACKBOX_URL'] = 'http://blackbox-test.yandex.net/blackbox'
    import warnings
    from travel.avia.library.python.common.utils.warnings import RaspDeprecationWarningDanger
    warnings.filterwarnings("error", category=RaspDeprecationWarningDanger)

    settings['ENVIRONMENT'] = 'testing'

    settings['DIRTY_LANG_URL'] = 'http://reqwizard.yandex.net:8891'

    settings['AVIA_BACK_URL'] = 'http://backend.testing.avia.yandex.net'
    settings['AVIA_BACK_PROD_URL'] = 'http://backend.production.avia.yandex.net'
    settings['RAVEN_CONFIG'] = {
        'dsn': os.getenv('SENTRY_DSN'),
    }
    settings['REST_HOST'] = 'int-api.tst.rasp.yandex.net'
    settings['RASPADMIN_HOST'] = 'production.service.admin.rasp.yandex-team.ru'

    settings['RSYNC_IMPORT_CONFIGS'] = {
        'rasp-media-data': [
            RsyncSource(
                host='rasp.admin-test.rasp.yandex.ru',
                share='rasp-media-data', exclude=[],
                copy_to=os.path.join(MEDIA_ROOT, 'data')
            ),
        ],
    }

    settings['TEST_WIZARD'] = False

    # Задержка при импорте 15 минут
    settings['AGENT_FETCH_DELAY'] = 900

    settings['SEND_CHANGES_REMINDERS'] = True
    settings['REMINDERS_HOST'] = 'reminders-api.calendar-back01e.tst.corba.yandex.net'

    ADMINS = settings['ADMINS'] = settings['MANAGERS'] = (('Rasp Testing', 'rasp-testing@yandex-team.ru'), )
    settings['PROCESS_RCPNTS'] = settings['ERROR404_RCPNTS'] = settings['TABLO_ERROR_RCPNTS'] = ADMINS
    settings['DATACHANGE_RCPNTS'] = settings['PROCESS_RCPNTS'] = settings['ERROR404_RCPNTS'] = ADMINS
    settings['TABLO_ERROR_RCPNTS'] = settings['EXPERSS_SUBST_RCPNTS'] = ADMINS
    settings['UNKNOWN_CODES_RCPNTS'] = settings['RASP_FREE_STATIONS_RCPNTS'] = ADMINS

    settings['ERRORS_RECIPIENTS'] = ['rasp-testing@yandex-team.ru']

    settings['SUBURBAN_CHANGE_NOTICES_FROM_EMAIL'] = '"Rasp Info Testing" <rasp-info@yandex-team.ru>'

    settings['OLVEN_USER'] = 'yandex'

    settings['YMAPS_KEY'] = os.getenv('YMAPS_KEY')

    settings['DOMAIN_NAMES'] = {
        ServiceInstance.code: 'testing.service.admin.rasp.yandex-team.ru',
        WorkInstance.code: 'testing.work.admin.rasp.yandex-team.ru'
    }

    settings['DOMAIN_NAME'] = settings['DOMAIN_NAMES'][INSTANCE_ROLE.code]

    if MIGRATION_INSTANCE:
        settings['MORDA_LINK'] = 'https://morda-migration.rasp.admin-test.rasp.yandex.ru'
    elif SERVICE_INSTANCE:
        settings['MORDA_LINK'] = 'https://morda-service.rasp.admin-test.rasp.yandex.ru'
    else:
        settings['MORDA_LINK'] = 'https://morda.rasp.admin-test.rasp.yandex.ru'

    # Конфиги для rsync и s3
    settings['S3_SYNC_CONFIGS'] = {
        'adwords': [
            ('avia-media/avia/files', os.path.join(MEDIA_ROOT, 'avia', 'files', 'recipes.xml'), []),
            ('avia-media/avia/files', os.path.join(MEDIA_ROOT, 'avia', 'files', 'points.xml'), []),
        ],
        'adwords_ru': [
            ('avia-media/avia/files', os.path.join(MEDIA_ROOT, 'avia', 'files', 'adwords_1250_3000_landing.xml'), []),
            ('avia-media/avia/files', os.path.join(MEDIA_ROOT, 'avia', 'files', 'adwords_1250_3000.xml'), []),
            ('avia-media/avia/files', os.path.join(MEDIA_ROOT, 'avia', 'files', 'adwords_head_landing.xml'), []),
            ('avia-media/avia/files', os.path.join(MEDIA_ROOT, 'avia', 'files', 'adwords_head.xml'), []),
            ('avia-media/avia/files', os.path.join(MEDIA_ROOT, 'avia', 'files', 'adwords_tail_landing.xml'), []),
            ('avia-media/avia/files', os.path.join(MEDIA_ROOT, 'avia', 'files', 'adwords_tail.xml'), []),
        ],
        'adwords_ua': [
            ('avia-media/avia/files', os.path.join(MEDIA_ROOT, 'avia', 'files', 'adwords_1250_3000_landing_ua.xml'), []),
            ('avia-media/avia/files', os.path.join(MEDIA_ROOT, 'avia', 'files', 'adwords_1250_3000_ua.xml'), []),
            ('avia-media/avia/files', os.path.join(MEDIA_ROOT, 'avia', 'files', 'adwords_head_landing_ua.xml'), []),
            ('avia-media/avia/files', os.path.join(MEDIA_ROOT, 'avia', 'files', 'adwords_head_ua.xml'), []),
            ('avia-media/avia/files', os.path.join(MEDIA_ROOT, 'avia', 'files', 'adwords_tail_landing_ua.xml'), []),
            ('avia-media/avia/files', os.path.join(MEDIA_ROOT, 'avia', 'files', 'adwords_tail_ua.xml'), []),
        ],

        'cohorts': [
            ('avia-media/avia', os.path.join(MEDIA_ROOT, 'avia', 'files', 'cohorts'), []),
        ],
        'feeds': [
            ('avia-media/avia', os.path.join(MEDIA_ROOT, 'avia', 'feeds'), []),
        ],
    }

    settings['POPULAR_DIRECTIONS_IMPORT_PROXY'] = 'kant.yt.yandex.net'

    settings['CLUSTER_CACHE_HOSTS'] = None

    settings['AVIA_PARTNER_FETCH_SUBJECT'] = 'testing'
    settings['AVIA_PARTNER_FETCH_MAIL'] = 'avia-partner-fetch-errors@yandex-team.ru'

    settings['AVIA_API_HOST'] = 'https://api.avia.lepus.yandex.net'

    settings['LOAD_LATEST_DB_ALLOWED'] = True
    settings['LOAD_LATEST_DB_TMP_DATABASE'] = 'rasp_tmp'

    settings['AVIA_STATS_ADMIN_HOST'] = 'stat.avia.tst.yandex-team.ru'
    settings['AVIA_STATS_IMPORT_USER'] = 'avia-admin-robot'
    settings['AVIA_STATS_IMPORT_PASSWORD'] = os.getenv('AVIA_STAT_IMPORT_PASSWORD')

    settings['FLIGHT_STATS_REQUEST_LIMIT'] = 10
    settings['FLIGHT_STATS_CREATE_ALERT'] = False

    settings['EMAIL_HOST'] = 'outbound-relay.yandex.net'


@EnvironmentSettings.register_config('sandbox_testing')
def configure_sandbox_testing(environment_settings, settings):
    configure_testing(environment_settings, settings)


@EnvironmentSettings.register_config('sandbox_production')
def configure_sandbox_production(environment_settings, settings):
    configure_production(environment_settings, settings)


@EnvironmentSettings.register_config('development')
def configure_development(environment_settings, settings):
    settings['DEBUG'] = True
    settings['SECRET_KEY'] = 'IndIbsasAdoowWishDeawgeetikyeejpicksyicKeenyojTheshgeuswedOgTyobbotonomNudanIckLyorbelUcOphdydLac'

    settings['YANDEX_TEAM_BLACKBOX_URL'] = 'http://blackbox.yandex-team.ru/blackbox'
    settings['YANDEX_BLACKBOX_URL'] = 'http://blackbox-mimino.yandex.net/blackbox'

    settings['BILLING_HOST'] = 'csbi-http-api.yandex.net'

    settings['OLVEN_USER'] = "yandex4"

    ADMINS = settings['ADMINS'] = settings['MANAGERS'] = (('Rasp Testing', 'rasp-testing@yandex-team.ru'), )
    settings['PROCESS_RCPNTS'] = settings['ERROR404_RCPNTS'] = settings['TABLO_ERROR_RCPNTS'] = ADMINS
    settings['DATACHANGE_RCPNTS'] = settings['PROCESS_RCPNTS'] = settings['ERROR404_RCPNTS'] = ADMINS
    settings['TABLO_ERROR_RCPNTS'] = settings['EXPERSS_SUBST_RCPNTS'] = ADMINS
    settings['UNKNOWN_CODES_RCPNTS'] = settings['RASP_FREE_STATIONS_RCPNTS'] = ADMINS
    settings['ERRORS_RECIPIENTS'] = ['rasp-testing@yandex-team.ru']

    # Конфиги для rsync и s3
    settings['MORDA_HOSTS'] = settings['WIZARD_HOSTS'] = []

    settings['LOAD_LATEST_DB_ALLOWED'] = True
    settings['LOAD_LATEST_DB_TMP_DATABASE'] = 'rasp_tmp'
    settings['LOAD_LATEST_DB_GRANT_SUPERUSER'] = True
    settings['LOAD_LATEST_DB_FULL'] = False

    for db in ('default', 'writable'):
        settings['DATABASES'][db]['HOST'] = os.getenv('AVIA_ADMIN_MYSQL_HOST', 'localhost')
        settings['DATABASES'][db]['USER'] = os.getenv('AVIA_ADMIN_MYSQL_USER', 'root')
        settings['DATABASES'][db]['PASSWORD'] = os.getenv('AVIA_ADMIN_MYSQL_PASSWORD', '')
        settings['DATABASES'][db]['PORT'] = os.getenv('AVIA_ADMIN_MYSQL_PORT', '')
        settings['DATABASES'][db]['NAME'] = os.getenv('AVIA_ADMIN_MYSQL_DATABASE_NAME', settings['DATABASES'][db]['NAME'])

    settings['AVIA_BACK_URL'] = 'http://backend.unstable.avia.yandex.net'

    if os.getenv('ENABLE_DEV_STATIC'):
        settings['STATIC_ROOT'] = os.getenv('STATIC_ROOT')
        settings['SERVE_STATIC_BY_GUNICORN'] = True
        settings['MEDIA_ROOT'] = os.getenv('MEDIA_ROOT')

    if os.getenv('SKIP_AUTH'):
        settings['ENABLE_TVM'] = False
        settings['YAUTH_USE_NATIVE_USER'] = False


def patch_host(host):
    return 'inet6:[%s]' % host


EnvironmentSettings.apply(globals(), use_master_db=True)


YT_TOKEN = os.getenv('YT_TOKEN')
YQL_TOKEN = os.getenv('YQL_TOKEN')
STATFACE_TOKEN = os.getenv('STATFACE_TOKEN')

YEAH_URL = os.getenv('AVIA_ADMIN_YEAH_URL')
TICKET_DAEMON_DNS_COMPONENT = os.getenv('AVIA_ADMIN_TICKET_DAEMON_DNS_COMPONENT', 'gunicorn.testing.avia-ticket-daemon.avia.stable.qloud-d.yandex.net')
TICKET_DAEMON_API_URL = os.getenv('AVIA_ADMIN_TICKET_DAEMON_API_URL', 'http://ticket-daemon-api.testing.avia.yandex.net')


def _allow_edit_sync_with_rasp_fields():
    # В проде всегда нужно запрещать редактирование полей, которые синкаются из расписаний,
    # потому что если разрешить, то можно, поменяв поле, погасить пожар, а потом все синкнеся обратно и опять пожар
    if YANDEX_ENVIRONMENT_TYPE == 'production':
        return False
    return os.getenv('ALLOW_EDIT_SYNC_WITH_RASP_FIELDS', False)


ALLOW_EDIT_SYNC_WITH_RASP_FIELDS = _allow_edit_sync_with_rasp_fields()
