# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import datetime
import django.core.validators
import travel.avia.admin.order.models
from travel.avia.library.python.common.utils.fields import TrimmedCharField, RegExpField, CodeCharField
from travel.avia.library.python.common.models.partner import PartnerLogoFileSystemStorage, DohopVendorLogoSvgUploadToGetter, DohopVendorLogoSvg2PngUploadToGetter, LogoSvg2PngUploadToGetter


class Migration(migrations.Migration):

    dependencies = [
        ('www', '0001_initial'),
        ('currency', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='ActualDirection',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
            ],
        ),
        migrations.CreateModel(
            name='BlablacarToken',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('token', models.TextField(verbose_name='\u0422\u043e\u043a\u0435\u043d')),
                ('expire_msk_dt', models.DateTimeField(verbose_name='\u0414\u0430\u0442\u0430 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0442\u043e\u043a\u0435\u043d\u0430')),  # noqa
                ('receive_msk_dt', models.DateTimeField(verbose_name='\u0414\u0430\u0442\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0442\u043e\u043a\u0435\u043d\u0430')),
            ],
            options={
                'verbose_name': '\u0422\u043e\u043a\u0435\u043d \u0434\u043b\u044f \u0431\u043b\u0430\u0431\u043b\u0430\u043a\u0430\u0440',
                'verbose_name_plural': '\u0422\u043e\u043a\u0435\u043d\u044b \u0434\u043b\u044f \u0431\u043b\u0430\u0431\u043b\u0430\u043a\u0430\u0440',
            },
        ),
        migrations.CreateModel(
            name='CoachInfo',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', TrimmedCharField(default=None, max_length=100, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435')),
                ('image', models.ImageField(upload_to=b'data/coachinfo/image', width_field=b'width', height_field=b'height', blank=True, null=True, verbose_name='\u0418\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435')),  # noqa
                ('width', models.IntegerField(verbose_name='\u0428\u0438\u0440\u0438\u043d\u0430', null=True, editable=False)),
                ('height', models.IntegerField(verbose_name='\u0412\u044b\u0441\u043e\u0442\u0430', null=True, editable=False)),
                ('schema', travel.avia.admin.order.models.CoachSchemaField(verbose_name='\u0421\u0445\u0435\u043c\u0430', db_column=b'schema')),
                ('seat_selection_algo', models.CharField(default=b'old', max_length=20, verbose_name='\u0410\u043b\u0433\u043e\u0440\u0438\u0442\u043c \u0432\u044b\u0431\u043e\u0440\u0430 \u043c\u0435\u0441\u0442', choices=[(b'old', '\u0421\u0442\u0430\u0440\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f'), (b'two-level', '\u0412\u0435\u0440\u0441\u0438\u044f \u043e\u0442 02.2015 \u0441 \u0432\u044b\u0431\u043e\u0440\u043e\u043c \u0434\u0432\u0443\u0445 \u043d\u0438\u0436\u043d\u0438\u0445')])),  # noqa
            ],
            options={
                'verbose_name': '\u0441\u0445\u0435\u043c\u0430 \u0432\u0430\u0433\u043e\u043d\u0430',
                'verbose_name_plural': '\u0441\u0445\u0435\u043c\u044b \u0432\u0430\u0433\u043e\u043d\u043e\u0432',
            },
        ),
        migrations.CreateModel(
            name='CoachInfoBinding',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('klass', models.CharField(max_length=100, verbose_name='\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f \u0432\u0430\u0433\u043e\u043d\u0430', choices=[('compartment', '\u043a\u0443\u043f\u0435'), ('suite', '\u043b\u044e\u043a\u0441'), ('sitting', '\u0441\u0438\u0434\u044f\u0447\u0438\u0439'), ('platzkarte', '\u043f\u043b\u0430\u0446\u043a\u0430\u0440\u0442'), ('soft', '\u043c\u044f\u0433\u043a\u0438\u0439'), ('common', '\u043e\u0431\u0449\u0438\u0439')])),  # noqa
                ('service_class', RegExpField(max_length=100, null=True, verbose_name='\u041a\u043b\u0430\u0441\u0441 \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u044f', blank=True)),  # noqa
                ('train_number', RegExpField(max_length=255, null=True, verbose_name='\u041d\u043e\u043c\u0435\u0440 \u043f\u043e\u0435\u0437\u0434\u0430', blank=True)),
                ('coach_number', RegExpField(max_length=255, null=True, verbose_name='\u041d\u043e\u043c\u0435\u0440 \u0432\u0430\u0433\u043e\u043d\u0430', blank=True)),
                ('priority', models.IntegerField(default=10, verbose_name='\u041f\u0440\u0438\u043e\u0440\u0438\u0442\u0435\u0442')),
                ('two_storey', models.BooleanField(default=False, verbose_name='\u0414\u0432\u0443\u0445\u044d\u0442\u0430\u0436\u043d\u044b\u0439 \u0432\u0430\u0433\u043e\u043d')),
                ('info', models.ForeignKey(verbose_name='\u0441\u0445\u0435\u043c\u0430', to='order.CoachInfo')),
            ],
            options={
                'verbose_name': '\u043f\u0440\u0438\u0432\u044f\u0437\u043a\u0430 \u0441\u0445\u0435\u043c\u044b \u0432\u0430\u0433\u043e\u043d\u0430',
                'verbose_name_plural': '\u043f\u0440\u0438\u0432\u044f\u0437\u043a\u0438 \u0441\u0445\u0435\u043c \u0432\u0430\u0433\u043e\u043d\u043e\u0432',
            },
        ),
        migrations.CreateModel(
            name='CoachService',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435', blank=True)),
                ('name_ru', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (ru)', blank=True)),
                ('name_en', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (en)', blank=True)),
                ('name_tr', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (tr)', blank=True)),
                ('name_uk', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (uk)', blank=True)),
            ],
            options={
                'verbose_name': '\u0443\u0441\u043b\u0443\u0433\u0430',
                'verbose_name_plural': '\u0443\u0441\u043b\u0443\u0433\u0438',
            },
        ),
        migrations.CreateModel(
            name='DohopVendor',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('description_ru_ru', models.TextField(null=True, verbose_name='\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0432 \u0440\u0443\u0441\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438', blank=True)),  # noqa
                ('description_ua_uk', models.TextField(null=True, verbose_name='\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0432 \u0443\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (uk)', blank=True)),  # noqa
                ('description_ua_ru', models.TextField(null=True, verbose_name='\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0432 \u0443\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (ru)', blank=True)),  # noqa
                ('description_tr_tr', models.TextField(null=True, verbose_name='\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0432 \u0442\u0443\u0440\u0435\u0446\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (tr)', blank=True)),  # noqa
                ('description_tr_en', models.TextField(null=True, verbose_name='\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0432 \u0442\u0443\u0440\u0435\u0446\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (en)', blank=True)),  # noqa
                ('dohop_code', models.CharField(max_length=100, verbose_name='\u041a\u043e\u0434 \u0432\u0435\u043d\u0434\u043e\u0440\u0430')),
                ('dohop_id', models.PositiveIntegerField(verbose_name='ID \u0432\u0435\u043d\u0434\u043e\u0440\u0430', db_index=True)),
                ('dohop_vendor_info', models.TextField()),
                ('dohop_residences', models.TextField()),
                ('dohop_langs', models.CharField(max_length=255)),
                ('review_percent', models.IntegerField(default=0, verbose_name='\u041f\u0440\u043e\u0446\u0435\u043d\u0442 \u043f\u0440\u043e\u0432\u0435\u0440\u043e\u043a')),
                ('logo_svg_ru', models.FileField(default=None, storage=PartnerLogoFileSystemStorage(), upload_to=DohopVendorLogoSvgUploadToGetter(b'ru'), blank=True, null=True, verbose_name='\u0426\u0432\u0435\u0442\u043d\u043e\u0439 \u043b\u043e\u0433\u043e\u0442\u0438\u043f \u0440\u0443\u0441\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 svg')),  # noqa
                ('logo_svg_ua', models.FileField(default=None, storage=PartnerLogoFileSystemStorage(), upload_to=DohopVendorLogoSvgUploadToGetter(b'ua'), blank=True, null=True, verbose_name='\u0426\u0432\u0435\u0442\u043d\u043e\u0439 \u043b\u043e\u0433\u043e\u0442\u0438\u043f \u0443\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 svg')),  # noqa
                ('logo_svg_tr', models.FileField(default=None, storage=PartnerLogoFileSystemStorage(), upload_to=DohopVendorLogoSvgUploadToGetter(b'tr'), blank=True, null=True, verbose_name='\u0426\u0432\u0435\u0442\u043d\u043e\u0439 \u043b\u043e\u0433\u043e\u0442\u0438\u043f \u0442\u0443\u0440\u0435\u0446\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 svg')),  # noqa
                ('logo_svg_com', models.FileField(default=None, storage=PartnerLogoFileSystemStorage(), upload_to=DohopVendorLogoSvgUploadToGetter(b'com'), blank=True, null=True, verbose_name='\u0426\u0432\u0435\u0442\u043d\u043e\u0439 \u043b\u043e\u0433\u043e\u0442\u0438\u043f com \u0432\u0435\u0440\u0441\u0438\u0438 \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 svg')),  # noqa
                ('logo_svg2png_ru', models.ImageField(default=None, storage=PartnerLogoFileSystemStorage(), upload_to=DohopVendorLogoSvg2PngUploadToGetter(b'ru'), blank=True, null=True, verbose_name='\u0420\u0435\u043d\u0434\u0435\u0440\u0435\u043d\u043d\u044b\u0439 svg2png \u043b\u043e\u0433\u043e\u0442\u0438\u043f \u0440\u0443\u0441\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438')),  # noqa
                ('logo_svg2png_ua', models.ImageField(default=None, storage=PartnerLogoFileSystemStorage(), upload_to=DohopVendorLogoSvg2PngUploadToGetter(b'ua'), blank=True, null=True, verbose_name='\u0420\u0435\u043d\u0434\u0435\u0440\u0435\u043d\u043d\u044b\u0439 svg2png \u043b\u043e\u0433\u043e\u0442\u0438\u043f \u0443\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438')),  # noqa
                ('logo_svg2png_tr', models.ImageField(default=None, storage=PartnerLogoFileSystemStorage(), upload_to=DohopVendorLogoSvg2PngUploadToGetter(b'tr'), blank=True, null=True, verbose_name='\u0420\u0435\u043d\u0434\u0435\u0440\u0435\u043d\u043d\u044b\u0439 svg2png \u043b\u043e\u0433\u043e\u0442\u0438\u043f \u0442\u0443\u0440\u0435\u0446\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438')),  # noqa
                ('logo_svg2png_com', models.ImageField(default=None, storage=PartnerLogoFileSystemStorage(), upload_to=DohopVendorLogoSvg2PngUploadToGetter(b'com'), blank=True, null=True, verbose_name='\u0420\u0435\u043d\u0434\u0435\u0440\u0435\u043d\u043d\u044b\u0439 svg2png \u043b\u043e\u0433\u043e\u0442\u0438\u043f com \u0432\u0435\u0440\u0441\u0438\u0438')),  # noqa
                ('enabled_in_ticket_ru', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u0438\u0437 \u041a\u0411 (ru)')),
                ('enabled_in_ticket_ua', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u0438\u0437 \u041a\u0411 (ua)')),
                ('enabled_in_ticket_tr', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u0438\u0437 \u041a\u0411 (tr)')),
                ('enabled_in_ticket_com', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u0438\u0437 \u041a\u0411 (com)')),
                ('enabled_in_rasp_ru', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u0438\u0437 \u041f\u041c (ru)')),
                ('enabled_in_rasp_ua', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u0438\u0437 \u041f\u041c (ua)')),
                ('enabled_in_rasp_tr', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u0438\u0437 \u041f\u041c (tr)')),
                ('enabled_in_mobile_ticket_ru', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u043d\u0430 \u043c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0445 \u0438\u0437 \u041a\u0411 (ru)')),  # noqa
                ('enabled_in_mobile_ticket_ua', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u043d\u0430 \u043c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0445 \u0438\u0437 \u041a\u0411 (ua)')),  # noqa
                ('enabled_in_mobile_ticket_tr', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u043d\u0430 \u043c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0445 \u0438\u0437 \u041a\u0411 (tr)')),  # noqa
                ('enabled_in_mobile_ticket_com', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u043d\u0430 \u043c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0445 \u0438\u0437 \u041a\u0411 (com)')),  # noqa
                ('enabled_in_mobile_rasp_ru', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u043d\u0430 \u043c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0445 \u0438\u0437 \u041f\u041c (ru)')),  # noqa
                ('enabled_in_mobile_rasp_ua', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u043d\u0430 \u043c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0445 \u0438\u0437 \u041f\u041c (ua)')),  # noqa
                ('enabled_in_mobile_rasp_tr', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u043d\u0430 \u043c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0445 \u0438\u0437 \u041f\u041c (tr)')),  # noqa
                ('enabled', models.BooleanField(default=False, verbose_name='\u041c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0448\u0435\u043d \u0447\u0435\u0440\u0435\u0437 \u0434\u0435\u043c\u043e\u043d\u0430')),  # noqa
                ('dohop_cache_ttl', models.PositiveSmallIntegerField(default=20, verbose_name='\u0412\u0440\u0435\u043c\u044f \u0436\u0438\u0437\u043d\u0438 \u043a\u0435\u0448\u0430, \u043c\u0438\u043d\u0443\u0442', validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(90)])),  # noqa
                ('foreign_currency', models.BooleanField(default=False, help_text='\u0418\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u0432 \u0432\u0430\u043b\u044e\u0442\u0430\u0445 \u043e\u0442\u043b\u0438\u0447\u043d\u044b\u0445 \u043e\u0442 \u0432\u0430\u043b\u044e\u0442\u044b \u043d\u0430\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438', verbose_name='\u0418\u043d\u043e\u0441\u0442\u0440\u0430\u043d\u043d\u044b\u0435 \u0432\u0430\u043b\u044e\u0442\u044b')),  # noqa
                ('query_module_name', models.CharField(default=None, max_length=255, null=True, verbose_name='\u0412\u0435\u0440\u0441\u0438\u044f \u043c\u043e\u0434\u0443\u043b\u044f', blank=True)),
                ('billing_datasource_id_dev', models.IntegerField(default=None, help_text='datasource ID', null=True, verbose_name='iD \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u0430 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430 dev', blank=True)),  # noqa
                ('billing_datasource_id_testing', models.IntegerField(default=None, help_text='datasource ID', null=True, verbose_name='iD \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u0430 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430 testing', blank=True)),  # noqa
                ('billing_datasource_id_production', models.IntegerField(default=None, help_text='datasource ID', null=True, verbose_name='iD \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u0430 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430 production', blank=True)),  # noqa
                ('click_price', models.FloatField(default=0, verbose_name='\u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u043a\u043b\u0438\u043a\u0430, \u0443.\u0435.')),
                ('is_aviacompany', models.BooleanField(default=False, verbose_name='\u0410\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u044f')),
                ('national_ua_title_ru', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0443\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (ru)', blank=True)),  # noqa
                ('national_ua_title_en', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0443\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (en)', blank=True)),  # noqa
                ('national_ua_title_tr', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0443\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (tr)', blank=True)),  # noqa
                ('national_ua_title_uk', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0443\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (uk)', blank=True)),  # noqa
                ('title', TrimmedCharField(default='', max_length=100, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u0430')),  # noqa
                ('title_ru', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u0430 (ru)', blank=True)),  # noqa
                ('title_en', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u0430 (en)', blank=True)),  # noqa
                ('title_tr', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u0430 (tr)', blank=True)),  # noqa
                ('title_uk', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u0430 (uk)', blank=True)),  # noqa
                ('national_ru_title_ru', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0440\u0443\u0441\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (ru)', blank=True)),  # noqa
                ('national_ru_title_en', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0440\u0443\u0441\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (en)', blank=True)),  # noqa
                ('national_ru_title_tr', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0440\u0443\u0441\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (tr)', blank=True)),  # noqa
                ('national_ru_title_uk', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0440\u0443\u0441\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (uk)', blank=True)),  # noqa
                ('national_tr_title_ru', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0442\u0443\u0440\u0435\u0446\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (ru)', blank=True)),  # noqa
                ('national_tr_title_en', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0442\u0443\u0440\u0435\u0446\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (en)', blank=True)),  # noqa
                ('national_tr_title_tr', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0442\u0443\u0440\u0435\u0446\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (tr)', blank=True)),  # noqa
                ('national_tr_title_uk', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0442\u0443\u0440\u0435\u0446\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (uk)', blank=True)),  # noqa
                ('national_com_ru', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 com \u0432\u0435\u0440\u0441\u0438\u0438 (ru)', blank=True)),  # noqa
                ('national_com_en', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 com \u0432\u0435\u0440\u0441\u0438\u0438 (en)', blank=True)),  # noqa
                ('national_com_tr', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 com \u0432\u0435\u0440\u0441\u0438\u0438 (tr)', blank=True)),  # noqa
                ('national_com_uk', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 com \u0432\u0435\u0440\u0441\u0438\u0438 (uk)', blank=True)),  # noqa
                ('t_type', models.ForeignKey(related_name='+', default=2, verbose_name='\u0442\u0438\u043f \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430', to='www.TransportType')),
            ],
            options={
                'verbose_name': '\u0432\u0435\u043d\u0434\u043e\u0440 Dohop',
                'verbose_name_plural': '\u0432\u0435\u043d\u0434\u043e\u0440\u044b Dohop',
            },
        ),
        migrations.CreateModel(
            name='Partner',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('site_url', models.CharField(max_length=255, verbose_name='\u0441\u0430\u0439\u0442 \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u0430')),
                ('code', CodeCharField(null=True, default=None, max_length=100, blank=True, unique=True, verbose_name='\u043a\u043e\u0434 \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u0430')),  # noqa
                ('billing_datasource_id_dev', models.IntegerField(default=None, help_text='datasource ID', null=True, verbose_name='iD \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u0430 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430 dev', blank=True)),  # noqa
                ('billing_datasource_id_testing', models.IntegerField(default=None, help_text='datasource ID', null=True, verbose_name='iD \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u0430 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430 testing', blank=True)),  # noqa
                ('billing_datasource_id_production', models.IntegerField(default=None, help_text='datasource ID', null=True, verbose_name='iD \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u0430 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430 production', blank=True)),  # noqa
                ('click_price', models.FloatField(verbose_name='\u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u043a\u043b\u0438\u043a\u0430, \u0443.\u0435.')),
                ('click_price_ru', models.FloatField(verbose_name='\u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u043a\u043b\u0438\u043a\u0430 \u0432 \u0420\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438, \u0443.\u0435.')),  # noqa
                ('click_price_ua', models.FloatField(verbose_name='\u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u043a\u043b\u0438\u043a\u0430 \u0432 \u0423\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438, \u0443.\u0435.')),  # noqa
                ('click_price_tr', models.FloatField(verbose_name='\u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u043a\u043b\u0438\u043a\u0430 \u0432 \u0422\u0443\u0440\u0435\u0446\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438, \u0443.\u0435.')),  # noqa
                ('click_price_com', models.FloatField(verbose_name='\u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u043a\u043b\u0438\u043a\u0430 \u0432 com \u0432\u0435\u0440\u0441\u0438\u0438, \u0443.\u0435.')),  # noqa
                ('current_balance', models.FloatField(default=0.0, verbose_name='\u0442\u0435\u043a\u0443\u0449\u0438\u0439 \u0431\u0430\u043b\u0430\u043d\u0441, \u0443.\u0435.')),
                ('notify_balance_threshold', models.FloatField(default=None, null=True, verbose_name='\u043f\u043e\u0440\u043e\u0433 \u0431\u0430\u043b\u0430\u043d\u0441\u0430 \u0434\u043b\u044f \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u044f, \u0443.\u0435.', blank=True)),  # noqa
                ('low_balance_notification_sent', models.DateTimeField(default=datetime.datetime(2011, 1, 1, 0, 0), verbose_name='\u0423\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0435 \u043e \u043d\u0438\u0437\u043a\u043e\u043c \u0431\u0430\u043b\u0430\u043d\u0441\u0435 \u043f\u043e\u0441\u043b\u0430\u043d\u043e')),  # noqa
                ('null_balance_notification_sent', models.DateTimeField(default=datetime.datetime(2011, 1, 1, 0, 0), verbose_name='\u0423\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0435 \u043e \u043d\u0443\u043b\u0435\u0432\u043e\u043c \u0431\u0430\u043b\u0430\u043d\u0441\u0435 \u043f\u043e\u0441\u043b\u0430\u043d\u043e')),  # noqa
                ('statistic_reminder_sent', models.DateTimeField(default=datetime.datetime(2011, 1, 1, 0, 0), verbose_name='\u041d\u0430\u043f\u043e\u043c\u0438\u043d\u0430\u043d\u0438\u0435 \u043f\u0440\u043e \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0443 \u043f\u0440\u043e\u0434\u0430\u0436 \u043f\u043e\u0441\u043b\u0430\u043d\u043e')),  # noqa
                ('balance_updated_at', models.DateTimeField(default=None, null=True, verbose_name='\u0431\u0430\u043b\u0430\u043d\u0441 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d', blank=True)),
                ('disabled', models.BooleanField(default=False, verbose_name='\u043f\u0440\u0438\u043d\u0443\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u043e\u0442\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u0430')),  # noqa
                ('foreign_currency', models.BooleanField(default=False, help_text='\u0418\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u0432 \u0432\u0430\u043b\u044e\u0442\u0430\u0445 \u043e\u0442\u043b\u0438\u0447\u043d\u044b\u0445 \u043e\u0442 \u0432\u0430\u043b\u044e\u0442\u044b \u043d\u0430\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438', verbose_name='\u0418\u043d\u043e\u0441\u0442\u0440\u0430\u043d\u043d\u044b\u0435 \u0432\u0430\u043b\u044e\u0442\u044b')),  # noqa
                ('enabled_in_ticket_ru', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u0438\u0437 \u041a\u0411 (ru)')),
                ('enabled_in_ticket_ua', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u0438\u0437 \u041a\u0411 (ua)')),
                ('enabled_in_ticket_tr', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u0438\u0437 \u041a\u0411 (tr)')),
                ('enabled_in_ticket_com', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u0438\u0437 \u041a\u0411 (com)')),
                ('enabled_in_rasp_ru', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u0438\u0437 \u041f\u041c (ru)')),
                ('enabled_in_rasp_ua', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u0438\u0437 \u041f\u041c (ua)')),
                ('enabled_in_rasp_tr', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u0438\u0437 \u041f\u041c (tr)')),
                ('enabled_in_mobile_ticket_ru', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u043d\u0430 \u043c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0445 \u0438\u0437 \u041a\u0411 (ru)')),  # noqa
                ('enabled_in_mobile_ticket_ua', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u043d\u0430 \u043c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0445 \u0438\u0437 \u041a\u0411 (ua)')),  # noqa
                ('enabled_in_mobile_ticket_tr', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u043d\u0430 \u043c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0445 \u0438\u0437 \u041a\u0411 (tr)')),  # noqa
                ('enabled_in_mobile_ticket_com', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u043d\u0430 \u043c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0445 \u0438\u0437 \u041a\u0411 (com)')),  # noqa
                ('enabled_in_mobile_rasp_ru', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u043d\u0430 \u043c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0445 \u0438\u0437 \u041f\u041c (ru)')),  # noqa
                ('enabled_in_mobile_rasp_ua', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u043d\u0430 \u043c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0445 \u0438\u0437 \u041f\u041c (ua)')),  # noqa
                ('enabled_in_mobile_rasp_tr', models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u043d\u0430 \u043c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0445 \u0438\u0437 \u041f\u041c (tr)')),  # noqa
                ('query_module_name', models.CharField(default=None, max_length=255, null=True, verbose_name='\u0412\u0435\u0440\u0441\u0438\u044f \u043c\u043e\u0434\u0443\u043b\u044f', blank=True)),
                ('logo', models.ImageField(default=b'', storage=PartnerLogoFileSystemStorage(), verbose_name='\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0439 \u043b\u043e\u0433\u043e\u0442\u0438\u043f', blank=True)),  # noqa
                ('logo_ru', models.ImageField(default=b'', storage=PartnerLogoFileSystemStorage(), verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f \u0440\u0443\u0441\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438', blank=True)),  # noqa
                ('logo_ua', models.ImageField(default=b'', storage=PartnerLogoFileSystemStorage(), verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f \u0443\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438', blank=True)),  # noqa
                ('logo_tr', models.ImageField(default=b'', storage=PartnerLogoFileSystemStorage(), verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f \u0442\u0443\u0440\u0435\u0446\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438', blank=True)),  # noqa
                ('logo_svg_ru', models.FileField(default=b'', storage=PartnerLogoFileSystemStorage(), verbose_name='\u0426\u0432\u0435\u0442\u043d\u043e\u0439 \u043b\u043e\u0433\u043e\u0442\u0438\u043f \u0440\u0443\u0441\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 svg', blank=True)),  # noqa
                ('logo_svg_ua', models.FileField(default=b'', storage=PartnerLogoFileSystemStorage(), verbose_name='\u0426\u0432\u0435\u0442\u043d\u043e\u0439 \u043b\u043e\u0433\u043e\u0442\u0438\u043f \u0443\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 svg', blank=True)),  # noqa
                ('logo_svg_tr', models.FileField(default=b'', storage=PartnerLogoFileSystemStorage(), verbose_name='\u0426\u0432\u0435\u0442\u043d\u043e\u0439 \u043b\u043e\u0433\u043e\u0442\u0438\u043f \u0442\u0443\u0440\u0435\u0446\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 svg', blank=True)),  # noqa
                ('logo_svg_com', models.FileField(default=b'', storage=PartnerLogoFileSystemStorage(), verbose_name='\u0426\u0432\u0435\u0442\u043d\u043e\u0439 \u043b\u043e\u0433\u043e\u0442\u0438\u043f com \u0432\u0435\u0440\u0441\u0438\u0438 \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 svg', blank=True)),  # noqa
                ('logo_svg2png_ru', models.ImageField(default=None, storage=PartnerLogoFileSystemStorage(), upload_to=LogoSvg2PngUploadToGetter(b'ru'), blank=True, null=True, verbose_name='\u0420\u0435\u043d\u0434\u0435\u0440\u0435\u043d\u043d\u044b\u0439 svg2png \u043b\u043e\u0433\u043e\u0442\u0438\u043f \u0440\u0443\u0441\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438')),  # noqa
                ('logo_svg2png_ua', models.ImageField(default=None, storage=PartnerLogoFileSystemStorage(), upload_to=LogoSvg2PngUploadToGetter(b'ua'), blank=True, null=True, verbose_name='\u0420\u0435\u043d\u0434\u0435\u0440\u0435\u043d\u043d\u044b\u0439 svg2png \u043b\u043e\u0433\u043e\u0442\u0438\u043f \u0443\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438')),  # noqa
                ('logo_svg2png_tr', models.ImageField(default=None, storage=PartnerLogoFileSystemStorage(), upload_to=LogoSvg2PngUploadToGetter(b'tr'), blank=True, null=True, verbose_name='\u0420\u0435\u043d\u0434\u0435\u0440\u0435\u043d\u043d\u044b\u0439 svg2png \u043b\u043e\u0433\u043e\u0442\u0438\u043f \u0442\u0443\u0440\u0435\u0446\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438')),  # noqa
                ('logo_svg2png_com', models.ImageField(default=None, storage=PartnerLogoFileSystemStorage(), upload_to=LogoSvg2PngUploadToGetter(b'com'), blank=True, null=True, verbose_name='\u0420\u0435\u043d\u0434\u0435\u0440\u0435\u043d\u043d\u044b\u0439 svg2png \u043b\u043e\u0433\u043e\u0442\u0438\u043f com \u0432\u0435\u0440\u0441\u0438\u0438')),  # noqa
                ('review_percent', models.IntegerField(default=10, verbose_name='\u041f\u0440\u043e\u0446\u0435\u043d\u0442 \u043f\u0440\u043e\u0432\u0435\u0440\u043e\u043a')),
                ('is_aviacompany', models.BooleanField(default=False, verbose_name='\u0410\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u044f')),
                ('can_fetch_by_daemon', models.BooleanField(default=True, help_text='\u041e\u0431\u044b\u0447\u043d\u043e \u044d\u0442\u043e\u0442 \u0447\u0435\u043a\u0431\u043e\u043a\u0441 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0432\u043a\u043b\u044e\u0447\u0435\u043d.\u041e\u0442\u043a\u043b\u044e\u0447\u0430\u0439\u0442\u0435 \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0436/\u0434 \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u043e\u0432, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u0437\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u044e\u0442\u0441\u044f \u043d\u0435 \u0447\u0435\u0440\u0435\u0437 \u0434\u0435\u043c\u043e\u043d.', verbose_name='\u041c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0448\u0435\u043d \u0447\u0435\u0440\u0435\u0437 \u0434\u0435\u043c\u043e\u043d\u0430')),  # noqa
                ('billing_order_id', models.IntegerField(default=None, null=True, verbose_name='\u041d\u043e\u043c\u0435\u0440 \u0437\u0430\u043a\u0430\u0437\u0430 \u0432 \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u043a\u0435', blank=True)),  # noqa
                ('national_com_title_ru', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 com \u0432\u0435\u0440\u0441\u0438\u0438 (ru)', blank=True)),  # noqa
                ('national_com_title_en', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 com \u0432\u0435\u0440\u0441\u0438\u0438 (en)', blank=True)),  # noqa
                ('national_com_title_tr', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 com \u0432\u0435\u0440\u0441\u0438\u0438 (tr)', blank=True)),  # noqa
                ('national_com_title_uk', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 com \u0432\u0435\u0440\u0441\u0438\u0438 (uk)', blank=True)),  # noqa
                ('national_ua_title_ru', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0443\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (ru)', blank=True)),  # noqa
                ('national_ua_title_en', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0443\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (en)', blank=True)),  # noqa
                ('national_ua_title_tr', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0443\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (tr)', blank=True)),  # noqa
                ('national_ua_title_uk', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0443\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (uk)', blank=True)),  # noqa
                ('title', TrimmedCharField(default='', max_length=100, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u0430')),  # noqa
                ('title_ru', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u0430 (ru)', blank=True)),  # noqa
                ('title_en', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u0430 (en)', blank=True)),  # noqa
                ('title_tr', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u0430 (tr)', blank=True)),  # noqa
                ('title_uk', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u0430 (uk)', blank=True)),  # noqa
                ('national_ru_title_ru', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0440\u0443\u0441\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (ru)', blank=True)),  # noqa
                ('national_ru_title_en', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0440\u0443\u0441\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (en)', blank=True)),  # noqa
                ('national_ru_title_tr', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0440\u0443\u0441\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (tr)', blank=True)),  # noqa
                ('national_ru_title_uk', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0440\u0443\u0441\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (uk)', blank=True)),  # noqa
                ('national_tr_title_ru', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0442\u0443\u0440\u0435\u0446\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (ru)', blank=True)),  # noqa
                ('national_tr_title_en', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0442\u0443\u0440\u0435\u0446\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (en)', blank=True)),  # noqa
                ('national_tr_title_tr', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0442\u0443\u0440\u0435\u0446\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (tr)', blank=True)),  # noqa
                ('national_tr_title_uk', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0442\u0443\u0440\u0435\u0446\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (uk)', blank=True)),  # noqa
                ('t_type', models.ForeignKey(related_name='order_partner', default=2, verbose_name='\u0442\u0438\u043f \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430', to='www.TransportType')),  # noqa
            ],
            options={
                'verbose_name': '\u043f\u0430\u0440\u0442\u043d\u0435\u0440',
                'verbose_name_plural': '\u043f\u0430\u0440\u0442\u043d\u0435\u0440\u044b',
            },
        ),
        migrations.CreateModel(
            name='PartnerEmail',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('email', models.EmailField(max_length=254)),
                ('partner', models.ForeignKey(related_name='emails', to='order.Partner')),
            ],
            options={
                'verbose_name': 'Email \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430',
                'verbose_name_plural': "Email'\u044b \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430",
            },
        ),
        migrations.CreateModel(
            name='QueryBlackList',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('flight_number', models.CharField(db_index=True, max_length=10, null=True, verbose_name='\u041d\u043e\u043c\u0435\u0440 \u0440\u0435\u0439\u0441\u0430', blank=True)),
                ('when_from', models.DateField(db_index=True, null=True, verbose_name='\u0414\u0430\u0442\u0430 \u0440\u0435\u0439\u0441\u0430 \u043e\u0442', blank=True)),
                ('when_to', models.DateField(db_index=True, null=True, verbose_name='\u0414\u0430\u0442\u0430 \u0440\u0435\u0439\u0441\u0430 \u0434\u043e', blank=True)),
                ('price_from', models.FloatField(null=True, verbose_name='\u0426\u0435\u043d\u0430 \u043e\u0442', blank=True)),
                ('price_to', models.FloatField(null=True, verbose_name='\u0426\u0435\u043d\u0430 \u0434\u043e', blank=True)),
                ('klass', models.CharField(blank=True, max_length=10, null=True, verbose_name='\u041a\u043b\u0430\u0441\u0441', choices=[('economy', '\u042d\u043a\u043e\u043d\u043e\u043c'), ('business', '\u0411\u0438\u0437\u043d\u0435\u0441'), ('first', '\u041f\u0435\u0440\u0432\u044b\u0439')])),  # noqa
                ('description', models.CharField(max_length=255, verbose_name='\u041f\u0440\u0438\u0447\u0438\u043d\u0430 \u0431\u0430\u043d\u0430')),
                ('active_to', models.DateField(verbose_name='\u0410\u043a\u0442\u0438\u0432\u043d\u043e \u0434\u043e', db_index=True)),
                ('active', models.BooleanField(db_index=True, verbose_name='\u0410\u043a\u0442\u0438\u0432\u043d\u043e')),
                ('company', models.ForeignKey(related_name='query_black_list_company', verbose_name='\u041f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a', blank=True, to='www.Company', null=True)),  # noqa
                ('country_from', models.ForeignKey(related_name='query_black_list_country_from', verbose_name='\u0441\u0442\u0440\u0430\u043d\u0430 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f', blank=True, to='www.Country', null=True)),  # noqa
                ('country_to', models.ForeignKey(related_name='query_black_list_country_to', verbose_name='\u0441\u0442\u0440\u0430\u043d\u0430 \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f', blank=True, to='www.Country', null=True)),  # noqa
                ('currency', models.ForeignKey(related_name='query_black_list_price_currency', verbose_name='\u0412\u0430\u043b\u044e\u0442\u0430', blank=True, to='currency.Currency', null=True)),
                ('partner', models.ForeignKey(verbose_name='\u043f\u0430\u0440\u0442\u043d\u0435\u0440', blank=True, to='order.Partner', null=True)),
                ('settlement_from', models.ForeignKey(related_name='query_black_list_settlement_from', verbose_name='\u0433\u043e\u0440\u043e\u0434 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f', blank=True, to='www.Settlement', null=True)),  # noqa
                ('settlement_to', models.ForeignKey(related_name='query_black_list_settlement_to', verbose_name='\u0433\u043e\u0440\u043e\u0434 \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f', blank=True, to='www.Settlement', null=True)),  # noqa
                ('station_from', models.ForeignKey(related_name='query_black_list_station_from', verbose_name='\u0441\u0442\u0430\u043d\u0446\u0438\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f', blank=True, to='www.Station', null=True)),  # noqa
                ('station_to', models.ForeignKey(related_name='query_black_list_station_to', verbose_name='\u0441\u0442\u0430\u043d\u0446\u0438\u044f \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f', blank=True, to='www.Station', null=True)),  # noqa
            ],
            options={
                'verbose_name': '\u043f\u0440\u0430\u0432\u0438\u043b\u043e \u0447\u0435\u0440\u043d\u043e\u0433\u043e \u0441\u043f\u0438\u0441\u043a\u0430',
                'verbose_name_plural': '\u043f\u0440\u0430\u0432\u0438\u043b\u0430 \u0447\u0435\u0440\u043d\u043e\u0433\u043e \u0441\u043f\u0438\u0441\u043a\u0430',
            },
        ),
        migrations.CreateModel(
            name='RegionalizePartnerQueryRule',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('exclude', models.BooleanField(default=False, verbose_name='\u043a\u0440\u043e\u043c\u0435')),
                ('country_from', models.ForeignKey(related_name='regionalize_query_from', verbose_name='\u0441\u0442\u0440\u0430\u043d\u0430 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f', blank=True, to='www.Country', null=True)),  # noqa
                ('country_to', models.ForeignKey(related_name='regionalize_query_to', verbose_name='\u0441\u0442\u0440\u0430\u043d\u0430 \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f', blank=True, to='www.Country', null=True)),  # noqa
                ('partner', models.ForeignKey(verbose_name='\u043f\u0430\u0440\u0442\u043d\u0435\u0440', to='order.Partner')),
                ('pseudo_region_from', models.ForeignKey(related_name='regionalize_query_from', verbose_name='\u043f\u0441\u0435\u0432\u0434\u043e\u0440\u0435\u0433\u0438\u043e\u043d \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f', blank=True, to='www.PseudoRegion', null=True)),  # noqa
                ('pseudo_region_to', models.ForeignKey(related_name='regionalize_query_to', verbose_name='\u043f\u0441\u0435\u0432\u0434\u043e\u0440\u0435\u0433\u0438\u043e\u043d \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f', blank=True, to='www.PseudoRegion', null=True)),  # noqa
                ('settlement_from', models.ForeignKey(related_name='regionalize_query_from', verbose_name='\u0433\u043e\u0440\u043e\u0434 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f', blank=True, to='www.Settlement', null=True)),  # noqa
                ('settlement_to', models.ForeignKey(related_name='regionalize_query_to', verbose_name='\u0433\u043e\u0440\u043e\u0434 \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f', blank=True, to='www.Settlement', null=True)),  # noqa
                ('user_country', models.ForeignKey(related_name='regionalize_query_user', verbose_name='\u0441\u0442\u0440\u0430\u043d\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f', blank=True, to='www.Country', null=True)),  # noqa
                ('user_pseudo_region', models.ForeignKey(related_name='regionalize_query_user', verbose_name='\u043f\u0441\u0435\u0432\u0434\u043e\u0440\u0435\u0433\u0438\u043e\u043d \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f', blank=True, to='www.PseudoRegion', null=True)),  # noqa
                ('user_settlement', models.ForeignKey(related_name='regionalize_query_user', verbose_name='\u0433\u043e\u0440\u043e\u0434 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f', blank=True, to='www.Settlement', null=True)),  # noqa
            ],
            options={
                'verbose_name': '\u043f\u0440\u0430\u0432\u0438\u043b\u043e \u0440\u0435\u0433\u0438\u043e\u043d\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438',
                'verbose_name_plural': '\u0440\u0435\u0433\u0438\u043e\u043d\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u0437\u0430\u043f\u0440\u043e\u0441\u043e\u0432 \u043a \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u0430\u043c',  # noqa
            },
        ),
        migrations.CreateModel(
            name='ServiceClass',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('owner', CodeCharField(max_length=100, null=True, verbose_name='\u0412\u043b\u0430\u0434\u0435\u043b\u0435\u0446 \u0432\u0430\u0433\u043e\u043d\u0430')),
                ('code', CodeCharField(max_length=100, verbose_name='\u041a\u043e\u0434')),
                ('is_brand', CodeCharField(default=b'any', max_length=100, verbose_name='\u0424\u0438\u0440\u043c\u0435\u043d\u043d\u044b\u0439', choices=[(b'any', '\u043d\u0435 \u0432\u0430\u0436\u043d\u043e'), (b'yes', '\u0434\u0430'), (b'no', '\u043d\u0435\u0442')])),  # noqa
                ('name', CodeCharField(max_length=100, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435')),
                ('note', CodeCharField(max_length=100, null=True, verbose_name='\u041f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u0435')),
                ('services', models.ManyToManyField(to='order.CoachService', verbose_name='\u0443\u0441\u043b\u0443\u0433\u0438', blank=True)),
            ],
            options={
                'verbose_name': '\u043a\u043b\u0430\u0441\u0441 \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u044f',
                'verbose_name_plural': '\u043a\u043b\u0430\u0441\u0441\u044b \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u044f',
            },
        ),
        migrations.CreateModel(
            name='ServiceClassNoteTranslate',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('value', TrimmedCharField(null=True, default=None, max_length=100, blank=True, unique=True, verbose_name='\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435')),
                ('value_ru', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 (ru)', blank=True)),
                ('value_en', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 (en)', blank=True)),
                ('value_tr', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 (tr)', blank=True)),
                ('value_uk', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 (uk)', blank=True)),
            ],
            options={
                'ordering': ('value',),
                'verbose_name': '\u043f\u0435\u0440\u0435\u0432\u043e\u0434 \u043f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u044f \u043a\u043b\u0430\u0441\u0441 \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u044f',  # noqa
                'verbose_name_plural': '\u043f\u0435\u0440\u0435\u0432\u043e\u0434\u044b \u043f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u0438 \u043a\u043b\u0430\u0441\u0441\u043e\u0432 \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u044f',  # noqa
            },
        ),
        migrations.CreateModel(
            name='StatisticsEntry',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('year', models.IntegerField(verbose_name='\u0433\u043e\u0434')),
                ('month', models.IntegerField(verbose_name='\u043c\u0435\u0441\u044f\u0446', choices=[(1, 1), (2, 2), (3, 3), (4, 4), (5, 5), (6, 6), (7, 7), (8, 8), (9, 9), (10, 10), (11, 11), (12, 12)])),  # noqa
                ('day', models.IntegerField(verbose_name='\u0434\u0435\u043d\u044c', choices=[(1, 1), (2, 2), (3, 3), (4, 4), (5, 5), (6, 6), (7, 7), (8, 8), (9, 9), (10, 10), (11, 11), (12, 12), (13, 13), (14, 14), (15, 15), (16, 16), (17, 17), (18, 18), (19, 19), (20, 20), (21, 21), (22, 22), (23, 23), (24, 24), (25, 25), (26, 26), (27, 27), (28, 28), (29, 29), (30, 30), (31, 31)])),  # noqa
                ('price', models.FloatField(verbose_name='\u0441\u0443\u043c\u043c\u0430 \u0437\u0430\u043a\u0430\u0437\u0430')),
                ('partner', models.ForeignKey(verbose_name='\u043f\u0430\u0440\u0442\u043d\u0435\u0440', to='order.Partner')),
            ],
            options={
                'ordering': ['year', 'month', 'day'],
            },
        ),
        migrations.AddField(
            model_name='actualdirection',
            name='partner',
            field=models.ForeignKey(verbose_name='\u043f\u0430\u0440\u0442\u043d\u0435\u0440', to='order.Partner'),
        ),
        migrations.AddField(
            model_name='actualdirection',
            name='settlement_from',
            field=models.ForeignKey(related_name='settlement_can_ask_from', default=None, blank=True, to='www.Settlement', null=True, verbose_name='\u043d\u0430\u0447\u0430\u043b\u044c\u043d\u044b\u0439 \u0433\u043e\u0440\u043e\u0434'),  # noqa
        ),
        migrations.AddField(
            model_name='actualdirection',
            name='settlement_to',
            field=models.ForeignKey(related_name='settlement_can_ask_to', default=None, blank=True, to='www.Settlement', null=True, verbose_name='\u043a\u043e\u043d\u0435\u0447\u043d\u044b\u0439 \u0433\u043e\u0440\u043e\u0434'),  # noqa
        ),
        migrations.AddField(
            model_name='actualdirection',
            name='station_from',
            field=models.ForeignKey(related_name='station_can_ask_from', verbose_name='\u043d\u0430\u0447\u0430\u043b\u044c\u043d\u0430\u044f \u0441\u0442\u0430\u043d\u0446\u0438\u044f', to='www.Station'),  # noqa
        ),
        migrations.AddField(
            model_name='actualdirection',
            name='station_to',
            field=models.ForeignKey(related_name='station_can_ask_to', verbose_name='\u043a\u043e\u043d\u0435\u0447\u043d\u0430\u044f \u0441\u0442\u0430\u043d\u0446\u0438\u044f', to='www.Station'),
        ),
    ]
