# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
from travel.avia.library.python.common.utils.fields import TrimmedCharField


class Migration(migrations.Migration):

    dependencies = [
        ('order', '0003_partner_status_update_model'),
    ]

    operations = [
        migrations.CreateModel(
            name='DohopIndex',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('code', TrimmedCharField(max_length=12, verbose_name='\u041a\u043e\u0434 \u0438\u043d\u0434\u0435\u043a\u0441\u0430')),
            ],
            options={
                'verbose_name': '\u0418\u043d\u0434\u0435\u043a\u0441 Dohop',
                'verbose_name_plural': '\u0418\u043d\u0434\u0435\u043a\u0441\u044b Dohop',
            },
        ),
        migrations.CreateModel(
            name='DohopVendorIndexInfo',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('vendor_info', models.TextField()),
                ('residences', models.TextField()),
                ('langs', models.CharField(max_length=255)),
                ('index', models.ForeignKey(related_name='vendors_infos', to='order.DohopIndex')),
                ('vendor', models.ForeignKey(related_name='index_infos', to='order.DohopVendor')),
            ],
            options={
                'verbose_name': '\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043f\u043e \u0432\u0435\u043d\u0434\u043e\u0440\u0443 \u0434\u043e\u0445\u043e\u043f \u0432 \u0438\u043d\u0434\u0435\u043a\u0441\u0435',  # noqa
                'verbose_name_plural': '\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043f\u043e \u0432\u0435\u043d\u0434\u043e\u0440\u0443 \u0434\u043e\u0445\u043e\u043f \u0432 \u0438\u043d\u0434\u0435\u043a\u0441\u0430\u0445',  # noqa
            },
        ),
        migrations.AlterUniqueTogether(
            name='dohopvendorindexinfo',
            unique_together=set([('vendor', 'index')]),
        ),
    ]
