# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models

from travel.avia.library.python.common.utils.fields import TrimmedCharField
from travel.avia.library.python.common.models.partner import PartnerLogoFileSystemStorage, LogoSvg2PngUploadToGetter


class Migration(migrations.Migration):

    dependencies = [
        ('order', '0005_unique_dohop_index'),
    ]

    operations = [
        migrations.AddField(
            model_name='partner',
            name='click_price_kz',
            field=models.FloatField(default=0, verbose_name='\u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u043a\u043b\u0438\u043a\u0430 (kz) \u0443.\u0435.', blank=True),  # noqa
        ),
        migrations.AddField(
            model_name='partner',
            name='enabled_in_mobile_rasp_kz',
            field=models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u043d\u0430 \u043c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0445 \u0438\u0437 \u041f\u041c (kz)'),  # noqa
        ),
        migrations.AddField(
            model_name='partner',
            name='enabled_in_mobile_ticket_kz',
            field=models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u043d\u0430 \u043c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0445 \u0438\u0437 \u041a\u0411 (kz)'),  # noqa
        ),
        migrations.AddField(
            model_name='partner',
            name='enabled_in_rasp_kz',
            field=models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u0438\u0437 \u041f\u041c (kz)'),
        ),
        migrations.AddField(
            model_name='partner',
            name='enabled_in_ticket_kz',
            field=models.BooleanField(default=False, verbose_name='\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u0438\u0437 \u041a\u0411 (kz)'),
        ),
        migrations.AddField(
            model_name='partner',
            name='logo_svg2png_kz',
            field=models.ImageField(default=None, storage=PartnerLogoFileSystemStorage(), upload_to=LogoSvg2PngUploadToGetter(b'kz'), blank=True, null=True, verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg2png (kz)'),  # noqa
        ),
        migrations.AddField(
            model_name='partner',
            name='logo_svg_kz',
            field=models.FileField(default=b'', storage=PartnerLogoFileSystemStorage(), verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg (kz)', blank=True),
        ),
        migrations.AddField(
            model_name='partner',
            name='national_kz_title_en',
            field=TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u043a\u0430\u0437\u0430\u0445\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (en)', blank=True),  # noqa
        ),
        migrations.AddField(
            model_name='partner',
            name='national_kz_title_ru',
            field=TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u043a\u0430\u0437\u0430\u0445\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (ru)', blank=True),  # noqa
        ),
        migrations.AddField(
            model_name='partner',
            name='national_kz_title_tr',
            field=TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u043a\u0430\u0437\u0430\u0445\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (tr)', blank=True),  # noqa
        ),
        migrations.AddField(
            model_name='partner',
            name='national_kz_title_uk',
            field=TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u043a\u0430\u0437\u0430\u0445\u0441\u043a\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 (uk)', blank=True),  # noqa
        ),
        migrations.AlterField(
            model_name='partner',
            name='click_price_com',
            field=models.FloatField(default=0, verbose_name='\u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u043a\u043b\u0438\u043a\u0430 (com) \u0443.\u0435.', blank=True),
        ),
        migrations.AlterField(
            model_name='partner',
            name='click_price_ru',
            field=models.FloatField(default=0, verbose_name='\u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u043a\u043b\u0438\u043a\u0430 (ru) \u0443.\u0435.', blank=True),
        ),
        migrations.AlterField(
            model_name='partner',
            name='click_price_tr',
            field=models.FloatField(default=0, verbose_name='\u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u043a\u043b\u0438\u043a\u0430 (tr) \u0443.\u0435.', blank=True),
        ),
        migrations.AlterField(
            model_name='partner',
            name='click_price_ua',
            field=models.FloatField(default=0, verbose_name='\u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u043a\u043b\u0438\u043a\u0430 (ua) \u0443.\u0435.', blank=True),
        ),
        migrations.AlterField(
            model_name='partner',
            name='logo_ru',
            field=models.ImageField(default=b'', storage=PartnerLogoFileSystemStorage(), verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f (ru)', blank=True),
        ),
        migrations.AlterField(
            model_name='partner',
            name='logo_svg2png_com',
            field=models.ImageField(default=None, storage=PartnerLogoFileSystemStorage(), upload_to=LogoSvg2PngUploadToGetter(b'com'), blank=True, null=True, verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg2png (com)'),  # noqa
        ),
        migrations.AlterField(
            model_name='partner',
            name='logo_svg2png_ru',
            field=models.ImageField(default=None, storage=PartnerLogoFileSystemStorage(), upload_to=LogoSvg2PngUploadToGetter(b'ru'), blank=True, null=True, verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg2png (ru)'),  # noqa
        ),
        migrations.AlterField(
            model_name='partner',
            name='logo_svg2png_tr',
            field=models.ImageField(default=None, storage=PartnerLogoFileSystemStorage(), upload_to=LogoSvg2PngUploadToGetter(b'tr'), blank=True, null=True, verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg2png (tr)'),  # noqa
        ),
        migrations.AlterField(
            model_name='partner',
            name='logo_svg2png_ua',
            field=models.ImageField(default=None, storage=PartnerLogoFileSystemStorage(), upload_to=LogoSvg2PngUploadToGetter(b'ua'), blank=True, null=True, verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg2png (ua)'),  # noqa
        ),
        migrations.AlterField(
            model_name='partner',
            name='logo_svg_com',
            field=models.FileField(default=b'', storage=PartnerLogoFileSystemStorage(), verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg (com)', blank=True),
        ),
        migrations.AlterField(
            model_name='partner',
            name='logo_svg_ru',
            field=models.FileField(default=b'', storage=PartnerLogoFileSystemStorage(), verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg (ru)', blank=True),
        ),
        migrations.AlterField(
            model_name='partner',
            name='logo_svg_tr',
            field=models.FileField(default=b'', storage=PartnerLogoFileSystemStorage(), verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg (tr)', blank=True),
        ),
        migrations.AlterField(
            model_name='partner',
            name='logo_svg_ua',
            field=models.FileField(default=b'', storage=PartnerLogoFileSystemStorage(), verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg (ua)', blank=True),
        ),
        migrations.AlterField(
            model_name='partner',
            name='logo_tr',
            field=models.ImageField(default=b'', storage=PartnerLogoFileSystemStorage(), verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f (tr)', blank=True),
        ),
        migrations.AlterField(
            model_name='partner',
            name='logo_ua',
            field=models.ImageField(default=b'', storage=PartnerLogoFileSystemStorage(), verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f (ua)', blank=True),
        ),
    ]
