# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations

from travel.avia.library.python.common.models.partner import (
    PartnerLogoFileSystemStorage, DohopVendorLogoSvgUploadToGetter, PartnerLogoUploadToGetter, LogoSvg2PngUploadToGetter,
    DohopVendorLogoSvg2PngUploadToGetter, PartnerLogoSvgUploadToGetter
)
from travel.avia.library.python.common.utils.media_fields import CustomImageField, SvgImageField


class Migration(migrations.Migration):

    dependencies = [
        ('order', '0008_unique_index_on_billing_order_id'),
    ]

    operations = [
        migrations.AlterField(
            model_name='dohopvendor',
            name='logo_svg2png_com',
            field=CustomImageField(default=None, storage=PartnerLogoFileSystemStorage(), upload_to=DohopVendorLogoSvg2PngUploadToGetter(b'com'), blank=True, null=True, verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg2png (com)'),  # noqa
        ),
        migrations.AlterField(
            model_name='dohopvendor',
            name='logo_svg2png_kz',
            field=CustomImageField(default=None, storage=PartnerLogoFileSystemStorage(), upload_to=DohopVendorLogoSvg2PngUploadToGetter(b'kz'), blank=True, null=True, verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg2png (kz)'),  # noqa
        ),
        migrations.AlterField(
            model_name='dohopvendor',
            name='logo_svg2png_ru',
            field=CustomImageField(default=None, storage=PartnerLogoFileSystemStorage(), upload_to=DohopVendorLogoSvg2PngUploadToGetter(b'ru'), blank=True, null=True, verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg2png (ru)'),  # noqa
        ),
        migrations.AlterField(
            model_name='dohopvendor',
            name='logo_svg2png_tr',
            field=CustomImageField(default=None, storage=PartnerLogoFileSystemStorage(), upload_to=DohopVendorLogoSvg2PngUploadToGetter(b'tr'), blank=True, null=True, verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg2png (tr)'),  # noqa
        ),
        migrations.AlterField(
            model_name='dohopvendor',
            name='logo_svg2png_ua',
            field=CustomImageField(default=None, storage=PartnerLogoFileSystemStorage(), upload_to=DohopVendorLogoSvg2PngUploadToGetter(b'ua'), blank=True, null=True, verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg2png (ua)'),  # noqa
        ),
        migrations.AlterField(
            model_name='dohopvendor',
            name='logo_svg_com',
            field=SvgImageField(default=None, storage=PartnerLogoFileSystemStorage(), upload_to=DohopVendorLogoSvgUploadToGetter(b'com'), blank=True, null=True, verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg (com)'),  # noqa
        ),
        migrations.AlterField(
            model_name='dohopvendor',
            name='logo_svg_kz',
            field=SvgImageField(default=None, storage=PartnerLogoFileSystemStorage(), upload_to=DohopVendorLogoSvgUploadToGetter(b'kz'), blank=True, null=True, verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg (kz)'),  # noqa
        ),
        migrations.AlterField(
            model_name='dohopvendor',
            name='logo_svg_ru',
            field=SvgImageField(default=None, storage=PartnerLogoFileSystemStorage(), upload_to=DohopVendorLogoSvgUploadToGetter(b'ru'), blank=True, null=True, verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg (ru)'),  # noqa
        ),
        migrations.AlterField(
            model_name='dohopvendor',
            name='logo_svg_tr',
            field=SvgImageField(default=None, storage=PartnerLogoFileSystemStorage(), upload_to=DohopVendorLogoSvgUploadToGetter(b'tr'), blank=True, null=True, verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg (tr)'),  # noqa
        ),
        migrations.AlterField(
            model_name='dohopvendor',
            name='logo_svg_ua',
            field=SvgImageField(default=None, storage=PartnerLogoFileSystemStorage(), upload_to=DohopVendorLogoSvgUploadToGetter(b'ua'), blank=True, null=True, verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg (ua)'),  # noqa
        ),
        migrations.AlterField(
            model_name='partner',
            name='logo',
            field=CustomImageField(default=b'', upload_to=PartnerLogoUploadToGetter(b''), storage=PartnerLogoFileSystemStorage(), verbose_name='\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0439 \u043b\u043e\u0433\u043e\u0442\u0438\u043f', blank=True),  # noqa
        ),
        migrations.AlterField(
            model_name='partner',
            name='logo_ru',
            field=CustomImageField(default=b'', upload_to=PartnerLogoUploadToGetter(b'ru'), storage=PartnerLogoFileSystemStorage(), verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f (ru)', blank=True),  # noqa
        ),
        migrations.AlterField(
            model_name='partner',
            name='logo_svg2png_com',
            field=CustomImageField(default=None, storage=PartnerLogoFileSystemStorage(), upload_to=LogoSvg2PngUploadToGetter(b'com'), blank=True, null=True, verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg2png (com)'),  # noqa
        ),
        migrations.AlterField(
            model_name='partner',
            name='logo_svg2png_kz',
            field=CustomImageField(default=None, storage=PartnerLogoFileSystemStorage(), upload_to=LogoSvg2PngUploadToGetter(b'kz'), blank=True, null=True, verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg2png (kz)'),  # noqa
        ),
        migrations.AlterField(
            model_name='partner',
            name='logo_svg2png_ru',
            field=CustomImageField(default=None, storage=PartnerLogoFileSystemStorage(), upload_to=LogoSvg2PngUploadToGetter(b'ru'), blank=True, null=True, verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg2png (ru)'),  # noqa
        ),
        migrations.AlterField(
            model_name='partner',
            name='logo_svg2png_tr',
            field=CustomImageField(default=None, storage=PartnerLogoFileSystemStorage(), upload_to=LogoSvg2PngUploadToGetter(b'tr'), blank=True, null=True, verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg2png (tr)'),  # noqa
        ),
        migrations.AlterField(
            model_name='partner',
            name='logo_svg2png_ua',
            field=CustomImageField(default=None, storage=PartnerLogoFileSystemStorage(), upload_to=LogoSvg2PngUploadToGetter(b'ua'), blank=True, null=True, verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg2png (ua)'),  # noqa
        ),
        migrations.AlterField(
            model_name='partner',
            name='logo_svg_com',
            field=SvgImageField(default=b'', upload_to=PartnerLogoSvgUploadToGetter(b'com'), storage=PartnerLogoFileSystemStorage(), verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg (com)', blank=True),  # noqa
        ),
        migrations.AlterField(
            model_name='partner',
            name='logo_svg_kz',
            field=SvgImageField(default=b'', upload_to=PartnerLogoSvgUploadToGetter(b'kz'), storage=PartnerLogoFileSystemStorage(), verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg (kz)', blank=True),  # noqa
        ),
        migrations.AlterField(
            model_name='partner',
            name='logo_svg_ru',
            field=SvgImageField(default=b'', upload_to=PartnerLogoSvgUploadToGetter(b'ru'), storage=PartnerLogoFileSystemStorage(), verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg (ru)', blank=True),  # noqa
        ),
        migrations.AlterField(
            model_name='partner',
            name='logo_svg_tr',
            field=SvgImageField(default=b'', upload_to=PartnerLogoSvgUploadToGetter(b'tr'), storage=PartnerLogoFileSystemStorage(), verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg (tr)', blank=True),  # noqa
        ),
        migrations.AlterField(
            model_name='partner',
            name='logo_svg_ua',
            field=SvgImageField(default=b'', upload_to=PartnerLogoSvgUploadToGetter(b'ua'), storage=PartnerLogoFileSystemStorage(), verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f svg (ua)', blank=True),  # noqa
        ),
        migrations.AlterField(
            model_name='partner',
            name='logo_tr',
            field=CustomImageField(default=b'', upload_to=PartnerLogoUploadToGetter(b'tr'), storage=PartnerLogoFileSystemStorage(), verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f (tr)', blank=True),  # noqa
        ),
        migrations.AlterField(
            model_name='partner',
            name='logo_ua',
            field=CustomImageField(default=b'', upload_to=PartnerLogoUploadToGetter(b'ua'), storage=PartnerLogoFileSystemStorage(), verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f (ua)', blank=True),  # noqa
        ),
    ]
