# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations


EMAIL_TYPES = [
    ['base', u'Основной'],
    ['stat', u'Статистический'],
]


def fill_email_types(apps, schema_editor):
    emailtype = apps.get_model("order", "EmailType")

    for code, title in EMAIL_TYPES:
        emailtype.objects.get_or_create(
            code=code,
            title=title
        )


class Migration(migrations.Migration):

    dependencies = [
        ('order', '0013_emailtype'),
    ]

    operations = [
        migrations.RunPython(fill_email_types, reverse_code=migrations.RunPython.noop),
    ]
