# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import datetime


def fill_histrory_update_records(apps, schema_editor):
    UpdateHistoryRecord = apps.get_model("order", "UpdateHistoryRecord")
    PartnerStatusUpdate = apps.get_model("order", "PartnerStatusUpdate")

    for status in PartnerStatusUpdate.objects.all():
        UpdateHistoryRecord(
            partner=status.partner,
            action='change-active-status',
            description='disabled: {}'.format(status.disabled),
            updater_yandex_login=status.updater_yandex_login,
            updater_role=status.updater_role,
            time=status.time
        ).save()


class Migration(migrations.Migration):

    dependencies = [
        ('order', '0017_auto_20160918_1951'),
    ]

    operations = [
        migrations.CreateModel(
            name='UpdateHistoryRecord',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('action', models.CharField(max_length=100, choices=[(b'change-active-status', b'change-active-status'), (b'change-unavailability-range', b'change-unavailability-range')])),
                ('description', models.CharField(max_length=100)),
                ('updater_yandex_login', models.CharField(max_length=255)),
                ('updater_role', models.CharField(max_length=255, choices=[(b'admin', b'admin'), (b'manager', b'manager'), (b'helper', b'helper'), (b'owner', b'owner')])),
                ('time', models.DateTimeField(default=datetime.datetime.utcnow, db_index=True)),
                ('partner', models.ForeignKey(related_name='history_update_records', to='order.Partner')),
            ],
            options={
                'db_table': 'order_updatehistoryrecords',
                'verbose_name': '\u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0438 \u0447\u0435\u0433\u043e-\u043b\u0438\u0431\u043e \u043a\u0435\u043c-\u0442\u043e',  # noqa
                'verbose_name_plural': '\u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0438 \u0447\u0435\u0433\u043e-\u043b\u0438\u0431\u043e \u043a\u0435\u043c-\u0442\u043e',  # noqa
            },
        ),

        migrations.RunPython(fill_histrory_update_records)

    ]
