# -*- coding: utf-8 -*-
from __future__ import unicode_literals
import json
import os

from django.db import migrations


def fill_logo2(apps, schema_editor):
    DohopVendor = apps.get_model('order', 'DohopVendor')
    Partner = apps.get_model('order', 'Partner')
    data_file = os.path.join(os.path.dirname(__file__), 'data/avatar_urls.json')

    with open(data_file) as f:
        urls = json.load(f)

    def get_url(field):
        if field:
            return urls.get('https://yastatic.net/rasp/media/{}'.format(field), '')
        return ''

    for partners in (
        Partner.objects.all(),
        DohopVendor.objects.all(),
    ):
        for p in partners:
            p.logo2_svg_ru = get_url(p.logo_svg_ru)
            p.logo2_svg_ua = get_url(p.logo_svg_ua)
            p.logo2_svg_kz = get_url(p.logo_svg_kz)
            p.logo2_svg_tr = get_url(p.logo_svg_tr)
            p.logo2_svg_com = get_url(p.logo_svg_com)
            p.logo2_svg2png_ru = get_url(p.logo_svg2png_ru)
            p.logo2_svg2png_ua = get_url(p.logo_svg2png_ua)
            p.logo2_svg2png_kz = get_url(p.logo_svg2png_kz)
            p.logo2_svg2png_tr = get_url(p.logo_svg2png_tr)
            p.logo2_svg2png_com = get_url(p.logo_svg2png_com)
            p.save()


def clear_logo2(apps, schema_editor):
    pass


class Migration(migrations.Migration):

    dependencies = [
        ('order', '0028_auto_20170129_1253'),
    ]

    operations = [
        migrations.RunPython(fill_logo2, reverse_code=clear_logo2),
    ]
