# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations


def fill_dohopvendor_codes(apps, schema_editor):
    DohopVendor = apps.get_model("order", "DohopVendor")

    for vendor in DohopVendor.objects.all():
        vendor.code = 'dohop_%s' % vendor.dohop_id
        vendor.save()


class Migration(migrations.Migration):

    dependencies = [
        ('order', '0031_dohopvendor_code'),
    ]

    operations = [
        migrations.RunPython(fill_dohopvendor_codes),
    ]
