# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations


def fill_dohopvendor_codes(apps, schema_editor):
    DohopVendor = apps.get_model("order", "DohopVendor")
    Partner = apps.get_model("order", "Partner")

    vendors = DohopVendor.objects.all()
    if len(vendors) == 0:
        return

    main_dohop, created = Partner.objects.get_or_create(code='dohop')
    for vendor in DohopVendor.objects.all():
        vendor.partner = main_dohop
        vendor.save()


class Migration(migrations.Migration):

    dependencies = [
        ('order', '0033_add_dohop_vendor_foreign_key_to_dohop'),
    ]

    operations = [
        migrations.RunPython(fill_dohopvendor_codes),
    ]
