# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import json
import os

from django.db import migrations


def fill_partner_client_id(apps, schema_editor):
    Partner = apps.get_model('order', 'Partner')
    data_file = os.path.join(os.path.dirname(__file__), 'data', 'balance_client_ids.json')

    with open(data_file) as f:
        client_ids = json.load(f)

    def get_client_id(field):
        if field and str(field) in client_ids:
            return client_ids[str(field)]
        return None

    for partner in Partner.objects.all():
        if not partner.billing_client_id:
            partner.billing_client_id = get_client_id(partner.billing_order_id)
            partner.save()


class Migration(migrations.Migration):

    dependencies = [
        ('order', '0039_partner_client_id'),
    ]

    operations = [
        migrations.RunPython(fill_partner_client_id),
    ]
