# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations

DEFAULT_PRICES_BY_NV = (
    ('ru', 2300),
    ('com', 30),
    ('tr', 100),
    ('kz', 7500),
)


def fill_pdefault_prices(apps, schema_editor):
    DefaultClickPrice = apps.get_model('order', 'DefaultClickPrice')
    NationalVersion = apps.get_model('avia_data', 'NationalVersion')

    for nv, price in DEFAULT_PRICES_BY_NV:
        nv = NationalVersion.objects.get(code=nv)
        DefaultClickPrice(billing_price=price, national_version=nv).save()


class Migration(migrations.Migration):
    dependencies = [
        ('order', '0041_defaultclickprice_pricelist'),
    ]

    operations = [
        migrations.RunPython(fill_pdefault_prices),
    ]
