# -*- coding: utf-8 -*-
from __future__ import unicode_literals
import csv
import os
from collections import namedtuple

from django.conf import settings
from django.db import migrations

ALLOWED_ENVS = ['production', 'testing']


def read_price_list():
    with open(os.path.join(os.path.dirname(__file__), 'data/0043_price_list_ru.csv')) as csvfile:
        csv_reader = csv.reader(csvfile)
        header = next(csv_reader)
        Row = namedtuple('Row', header)
        for row in csv_reader:
            yield Row(*map(int, row))


def fill_price_list(apps, schema_editor):
    if settings.ENVIRONMENT not in ALLOWED_ENVS:
        return

    PriceList = apps.get_model('order', 'PriceList')
    NationalVersion = apps.get_model('avia_data', 'NationalVersion')

    def prices():
        nv = NationalVersion.objects.get(code='ru')
        for price in read_price_list():
            yield PriceList(
                settlement_from_id=price.from_id,
                settlement_to_id=price.to_id,
                month=price.month,
                is_one_way=bool(price.is_one_way),
                price=price.price,
                national_version_id=nv.id
            )
    PriceList.objects.bulk_create(prices())


class Migration(migrations.Migration):
    dependencies = [
        ('order', '0042_fill_default_click_prices'),
    ]

    operations = [
        migrations.RunPython(fill_price_list),
    ]
