# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models


REDIRECT_TYPES = [
    ('direct_rasp', 'Прямые переходы с расписаний'),
    ('direct_wizard', 'Прямые переходы с колдунщика'),
    ('direct_sovetnik', 'Прямые переходы с советника'),
    ('inderect', 'Непрямые переходы'),
]


def fill_redirect_type(apps, schema_editor):
    RedirectType = apps.get_model('order', 'RedirectType')
    for code, name in REDIRECT_TYPES:
        RedirectType(code=code, name=name).save()


class Migration(migrations.Migration):

    dependencies = [
        ('order', '0046_cpc_prices'),
    ]

    operations = [
        migrations.CreateModel(
            name='RedirectType',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('code', models.CharField(unique=True, max_length=20, verbose_name='\u041a\u043e\u0434')),
                ('name', models.CharField(max_length=100, verbose_name='\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435')),
            ],
            options={
                'verbose_name': '\u0422\u0438\u043f \u0440\u0435\u0434\u0438\u0440\u0435\u043a\u0442\u0430 \u0434\u043b\u044f \u0440\u0430\u0441\u0447\u0435\u0442\u0430 \u0446\u0435\u043d',
                'verbose_name_plural': '\u0422\u0438\u043f\u044b \u0440\u0435\u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0432 \u0434\u043b\u044f \u0440\u0430\u0441\u0447\u0435\u0442\u0430 \u0446\u0435\u043d',  # noqa
            },
        ),
        migrations.RunPython(fill_redirect_type),
    ]
