# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models


BILLING_ORDER_ID = frozenset({  # BILLING_ORDER_ID
    23,     # ozon
    270,    # svyaznoy
    377,    # expressavia
    437,    # citytravel
    468,    # aviakass
    1005,   # uzairways
    1007,   # superkassa
    20,     # biletix
    1025,   # tripcom
    438,    # agent
    430,    # biletdv
    1031,   # megotravel
    1023,   # tinkoff1
    1016,   # clickavia
    1014,   # kupibilet
    1028,   # biletinet (vertas)
    1001,   # ticketsru
    1012,   # kiwi
    1019,   # biletikaeroag
    1015,   # booktripruag
    203,    # aviaoperator
})


def enadle_partner_in_update_conversion(apps, schema_editor):
    model = apps.get_model('order', 'partner')
    for partner in model.objects.all():
        if partner.billing_order_id in BILLING_ORDER_ID:
            partner.use_in_update_conversions = True
            partner.save()


class Migration(migrations.Migration):

    dependencies = [
        ('order', '0056_regionalization_pobeda_fields'),
    ]

    operations = [
        migrations.AddField(
            model_name='partner',
            name='use_in_update_conversions',
            field=models.BooleanField(default=False, null=False, verbose_name='\u0423\u0447\u0438\u0442\u044b\u0432\u0430\u0442\u044c \u0432 \u0440\u0430\u0441\u0447\u0435\u0442\u0435 \u043a\u043e\u043d\u0432\u0435\u0440\u0441\u0438\u0438'),  # noqa
        ),
        migrations.RunPython(
            enadle_partner_in_update_conversion
        ),
    ]
