# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import functools

from django.db import migrations, models
import django.core.validators


model_map = {
    'partner': {
        'partner_model': 'Partner',
        'ttl_model': 'PartnerVariantsTTL',
    },
    'dohop': {
        'partner_model': 'DohopVendor',
        'ttl_model': 'DohopVariantsTTL',
        'ttl_field': 'dohop_cache_ttl',
    },
    'amadeus': {
        'partner_model': 'AmadeusMerchant',
        'ttl_model': 'AmadeusMerchantVariantsTTL',
        'partner_app_label': 'avia_data',
    },
}


def set_default_variant_ttl(
        apps, schema_editor,
        partner_model, ttl_model,
        partner_app_label='order',
        ttl_app_label='order',
        ttl_field='variant_cache_ttl',
):
    model = apps.get_model(partner_app_label, partner_model.lower())
    ttl_model = apps.get_model(ttl_app_label, ttl_model.lower())
    ttl_objects = []
    for partner in model.objects.values('id', ttl_field).all():
        ttl_objects.extend([
            ttl_model(partner_id=partner['id'], search_depth=3, ttl=partner[ttl_field]),
            ttl_model(partner_id=partner['id'], ttl=partner[ttl_field])
        ])
    ttl_model.objects.bulk_create(ttl_objects)


class Migration(migrations.Migration):

    dependencies = [
        ('avia_data', '0076_auto_20200611_1019'),
        ('order', '0062_add_is_deleted_to_partner'),
    ]

    operations = [
        migrations.CreateModel(
            name='AmadeusMerchantVariantsTTL',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('search_depth', models.IntegerField(null=True, verbose_name='\u0413\u043b\u0443\u0431\u0438\u043d\u0430 \u043f\u043e\u0438\u0441\u043a\u0430, \u0434\u043d\u0435\u0439', blank=True)),
                ('ttl', models.IntegerField(verbose_name='\u0412\u0440\u0435\u043c\u044f \u0436\u0438\u0437\u043d\u0438 \u043a\u0435\u0448\u0430, \u043c\u0438\u043d\u0443\u0442', validators=[django.core.validators.MinValueValidator(3)])),  # noqa
                ('partner', models.ForeignKey(related_name='variants_ttl', verbose_name='\u041f\u0430\u0440\u0442\u043d\u0435\u0440', to='avia_data.AmadeusMerchant')),
            ],
            options={
                'abstract': False,
                'db_table': 'order_amadeusmerchant_variantsttl',
                'verbose_name': '\u0432\u0440\u0435\u043c\u044f \u0436\u0438\u0437\u043d\u0438 \u043a\u0435\u0448\u0430 \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u0430',
                'verbose_name_plural': '\u0432\u0440\u0435\u043c\u044f \u0436\u0438\u0437\u043d\u0438 \u043a\u0435\u0448\u0430 \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u043e\u0432',
            },
        ),
        migrations.CreateModel(
            name='DohopVariantsTTL',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('search_depth', models.IntegerField(null=True, verbose_name='\u0413\u043b\u0443\u0431\u0438\u043d\u0430 \u043f\u043e\u0438\u0441\u043a\u0430, \u0434\u043d\u0435\u0439')),
                ('ttl', models.IntegerField(verbose_name='\u0412\u0440\u0435\u043c\u044f \u0436\u0438\u0437\u043d\u0438 \u043a\u0435\u0448\u0430, \u043c\u0438\u043d\u0443\u0442', validators=[django.core.validators.MinValueValidator(3)])),  # noqa
            ],
            options={
                'abstract': False,
                'verbose_name': '\u0432\u0440\u0435\u043c\u044f \u0436\u0438\u0437\u043d\u0438 \u043a\u0435\u0448\u0430 \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u0430',
                'verbose_name_plural': '\u0432\u0440\u0435\u043c\u044f \u0436\u0438\u0437\u043d\u0438 \u043a\u0435\u0448\u0430 \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u043e\u0432',
            },
        ),
        migrations.CreateModel(
            name='PartnerVariantsTTL',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('search_depth', models.IntegerField(null=True, verbose_name='\u0413\u043b\u0443\u0431\u0438\u043d\u0430 \u043f\u043e\u0438\u0441\u043a\u0430, \u0434\u043d\u0435\u0439')),
                ('ttl', models.IntegerField(verbose_name='\u0412\u0440\u0435\u043c\u044f \u0436\u0438\u0437\u043d\u0438 \u043a\u0435\u0448\u0430, \u043c\u0438\u043d\u0443\u0442', validators=[django.core.validators.MinValueValidator(3)])),  # noqa
            ],
            options={
                'abstract': False,
                'verbose_name': '\u0432\u0440\u0435\u043c\u044f \u0436\u0438\u0437\u043d\u0438 \u043a\u0435\u0448\u0430 \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u0430',
                'verbose_name_plural': '\u0432\u0440\u0435\u043c\u044f \u0436\u0438\u0437\u043d\u0438 \u043a\u0435\u0448\u0430 \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u043e\u0432',
            },
        ),
        migrations.AddField(
            model_name='partnervariantsttl',
            name='partner',
            field=models.ForeignKey(related_name='variants_ttl', verbose_name='\u041f\u0430\u0440\u0442\u043d\u0435\u0440', to='order.Partner'),
        ),
        migrations.AddField(
            model_name='dohopvariantsttl',
            name='partner',
            field=models.ForeignKey(related_name='variants_ttl', verbose_name='\u041f\u0430\u0440\u0442\u043d\u0435\u0440', to='order.DohopVendor'),
        ),
        migrations.RunPython(
            functools.partial(set_default_variant_ttl, **model_map['amadeus'])
        ),
        migrations.RunPython(
            functools.partial(set_default_variant_ttl, **model_map['partner'])
        ),
        migrations.RunPython(
            functools.partial(set_default_variant_ttl, **model_map['dohop'])
        ),
    ]
