# -*- coding: utf-8 -*-

from __future__ import absolute_import

from travel.avia.admin.avia.models import AviaWizardDirection


def precalc_avia_directions(connect, precalc_state):
    directions = AviaWizardDirection.objects.all()

    conn = connect()

    conn.executescript("""
        DROP TABLE IF EXISTS avia_directions;

        CREATE TABLE avia_directions (
            id INTEGER PRIMARY KEY,
            settlement_1_id INTEGER NOT NULL,
            settlement_2_id INTEGER NOT NULL
        );

        CREATE INDEX avia_directions_index ON avia_directions(settlement_1_id, settlement_2_id);
    """)

    def iter_rows():
        for direction in directions:
            yield (direction.settlement_1_id, direction.settlement_2_id)
            yield (direction.settlement_2_id, direction.settlement_1_id)

    conn.executemany("""
        INSERT INTO avia_directions VALUES (NULL, ?, ?)
    """, iter_rows())

    conn.commit()
    conn.close()
