# -*- coding: utf-8 -*-
from __future__ import absolute_import

from itertools import groupby, islice

from travel.avia.library.python.common.models.transport import TransportType

from travel.avia.admin.lib.parallelize import fork_imap_unordered
from travel.avia.admin.precalc.utils.estimator import TheEstimator


def iter_slices(iterable, size):
    it = iter(iterable)

    while True:
        iterable_slice = list(islice(it, size))

        if not iterable_slice:
            return

        yield iterable_slice


def normalize_string(s):
    if s is None:
        return None

    return s.strip().lower()


def split_to_bins(record_iter, groupby_key, binsize=50000):
    bin = []

    for grouper, records in groupby(record_iter, key=groupby_key):
        bin.extend(records)

        if len(bin) < binsize:
            continue

        yield bin

        bin = []

    # Обрабатываем последние записи
    if bin:
        yield bin


def map_groups_forked(func, iterable, iterable_size, groupby_key,
                      chunksize=50000, n_workers=16):
    counter = TheEstimator(iterable_size)

    def _callback(objects):
        func(objects)
        return len(objects)

    bins = split_to_bins(iterable, groupby_key, chunksize)

    for done_count in fork_imap_unordered(_callback, bins, n_workers):
        counter.update(done_count)


def replace_water_t_type(t_type_id):
    return (
        TransportType.WATER_ID
        if t_type_id in TransportType.WATER_TTYPE_IDS else
        t_type_id
    )
