# -*- coding: utf-8 -*-

from __future__ import absolute_import

from django.utils.functional import cached_property

from travel.avia.admin.precalc.utils import iter_slices


class ChunkedSizedMap(object):

    def __init__(self, func, queryset, pk_index,
                 chunk_size=100000, object_ids=None):
        self.func = func
        self.queryset = queryset
        self.pk_index = pk_index
        self.chunk_size = chunk_size
        self.object_ids = object_ids

    @cached_property
    def _pks(self):
        pks = self.queryset.values_list('pk', flat=True)

        if self.object_ids is None:
            return list(pks)

        return [
            pk
            for ids_part in iter_slices(self.object_ids, self.chunk_size)
            for pk in pks.filter(id__in=ids_part)
        ]

    def __iter__(self):
        new_qs = self.queryset.values_list(*self.queryset.field_names).order_by()

        pk_index = self.pk_index
        func = self.func
        for pks_part in iter_slices(self._pks, self.chunk_size):
            objects = {
                obj[pk_index]: obj
                for obj in new_qs.filter(id__in=pks_part)
            }

            for pk in pks_part:
                yield func(*objects[pk])

    def __len__(self):
        return len(self._pks)
