# -*- coding: utf-8 -*-

from __future__ import absolute_import

import logging
from time import time as unix_time


class TheEstimator(object):
    def __init__(self, count, log=None):
        self.count = count
        self.processed = 0

        self.start_time = None
        self.start_count = 0
        self.percent = 0
        self.estimated = None

        self.log = log or logging.getLogger('precalc')

    def update(self, processed):
        self.processed += processed

        t = unix_time()

        if self.start_time is None:
            self.start_time = t
            self.start_count = processed

        elapsed = t - self.start_time

        percent = self.processed * 100 / self.count

        if percent != self.percent or elapsed and not self.estimated:
            if elapsed > 0:
                average_rate = (self.processed - self.start_count) / elapsed

                estimated = (self.count - self.start_count) / average_rate

                remaining = estimated - elapsed

                self.log.info('%d of %d (%d%%), estimated %d, remaining %d' % (
                    self.processed, self.count, percent, estimated, remaining
                ))

                self.estimated = estimated
            else:
                self.log.info('%d of %d (%d%%)' % (
                    self.processed, self.count, percent
                ))

            self.percent = percent
