# -*- coding: utf-8 -*-

from __future__ import absolute_import

from travel.avia.library.python.common.models.schedule import Company
from travel.avia.library.python.common.models.transport import TransportType


def get_airlines(code):
    airlines = set()

    for key in ['sirena_id', 'iata', 'icao']:
        q = {'%s__iexact' % key: code}

        airlines.update(Company.objects.filter(**q))

    return list(airlines)


def strip_zeroes(number):
    if not len(number):
        return number

    zeroes = set()

    for i, (c, p) in enumerate(number):
        if c == '0':
            zeroes.update(p)
            continue

        break

    return [(c, p.union(zeroes))] + number[i + 1:]


def _generate_number_keys(t_type_id, number):
    number = [(c.lower(), set([i])) for i, c in enumerate(number)]

    if t_type_id == TransportType.PLANE_ID:
        try:
            space_index = [c for c, p in number].index(' ')

            letters = number[:space_index]
            digits = number[space_index + 1:]
        except ValueError:
            letters, digits = number[:2], number[2:]

        airlines = get_airlines(flatten_number_key(letters))

        if airlines:
            # Размазываем позиции исходного кода по всем транслированным кодам
            code_positions = set(p for c, cp in letters for p in cp)

            for key in ['sirena_id', 'iata', 'icao']:
                for airline in airlines:
                    code = getattr(airline, key)

                    if code:
                        letters = [(c.lower(), code_positions) for c in code]

                        yield letters + strip_zeroes(digits)

        else:
            yield letters + strip_zeroes(digits)

        yield strip_zeroes(digits)

    elif t_type_id == TransportType.TRAIN_ID:
        digits = [(c, p) for c, p in number if c.isdigit()]

        yield strip_zeroes(number)
        yield strip_zeroes(digits)

    else:
        yield strip_zeroes(number)


def flatten_number_key(key):
    if key is None:
        return None

    return "".join(c for c, p in key)


def generate_number_keys(t_type_id, number):
    ready = set()

    for key in _generate_number_keys(t_type_id, number):
        flat = flatten_number_key(key)

        if flat not in ready:
            yield key

            ready.add(flat)
