# -*- coding: utf-8 -*-

from django.contrib import admin

from travel.avia.admin.lib.admin_options import RaspExportModelAdmin

from travel.avia.admin.promosearch.models import PromoSettlement, ScheduleTable, TariffTable, PromoPage


class PromoSettlementInline(admin.TabularInline):
    model = PromoSettlement
    raw_id_fields = ('settlement',)


class ScheduleTableInline(admin.TabularInline):
    model = ScheduleTable
    raw_id_fields = ('company', 'station_from', 'station_to')


class TariffTableInline(admin.TabularInline):
    model = TariffTable
    raw_id_fields = ('company', 'station_from', 'station_to')


class PromoPageAdmin(RaspExportModelAdmin):
    inlines = [PromoSettlementInline, ScheduleTableInline, TariffTableInline]
    list_display = ('title', 'active')


admin.site.register(PromoPage, PromoPageAdmin)
