# -*- coding: utf-8 -*-

import travel.avia.admin.init_project  # noqa

import logging

from django.db import connection, transaction

from travel.avia.library.python.common.utils.unicode_csv import UnicodeWriter
from travel.avia.admin.lib import tmpfiles
from travel.avia.admin.lib.logs import create_current_file_run_log, print_log_to_stdout
from travel.avia.admin.www.models.precalc import NameSearchIndex


log = logging.getLogger(__name__)


@tmpfiles.clean_temp
@transaction.atomic
def run(truncate_table=False):
    log.info(u'Computing namesearchindex')

    tmp_file_name = tmpfiles.get_tmp_filepath('namesearchindex.tsv')
    tmp_file = open(tmp_file_name, 'w')
    csv_writer = UnicodeWriter(tmp_file, delimiter="\t", lineterminator="\n")

    for row in NameSearchIndex.get_records():
        csv_writer.writerow(map(lambda v: v and unicode(v) or 'NULL', row))

    tmp_file.flush()
    tmp_file.close()

    cursor = connection.cursor()

    if truncate_table:
        log.info(u'Truncating table')
        cursor.execute('TRUNCATE `{}`'.format(NameSearchIndex._meta.db_table))
    else:
        log.info(u'Deleting old data')
        cursor.execute('DELETE FROM `{}`'.format(NameSearchIndex._meta.db_table))

    log.info(u'Loading data')

    cursor.execute("""
    LOAD DATA LOCAL INFILE %s REPLACE INTO TABLE www_namesearchindex
        CHARACTER SET utf8 FIELDS OPTIONALLY ENCLOSED BY '"'
    (
        text, content_type_id, object_id, exact
    )
    """, [tmp_file_name])


def main():
    import argparse

    create_current_file_run_log()

    parser = argparse.ArgumentParser()
    parser.add_argument('-v', '--verbose', action='store_true')
    parser.add_argument('--truncate', action='store_true')

    args = parser.parse_args()
    if args.verbose:
        print_log_to_stdout(log)

    run(truncate_table=args.truncate)
