# -*- encoding: utf-8 -*-

import travel.avia.admin.init_project  # noqa

import logging
import os

from travel.avia.library.python.common.utils.currency_converter import ConverterCache
from travel.avia.admin.lib.logs import print_log_to_stdout, create_current_file_run_log

module_name = os.path.basename(__file__)[:-3]
log = logging.getLogger(__name__)


def run():
    try:
        rates_cache = ConverterCache.build()
    except RuntimeError as e:
        log.info(e[0])
    else:
        try:
            rates_cache.save(cluster=True)
        except Exception:
            log.exception('')
        else:
            log.info(
                '%s %s',
                rates_cache.actual_datetime.strftime('%Y-%m-%dT%H:%M:%S'),
                rates_cache.rates
            )


def main():
    from optparse import OptionParser

    parser = OptionParser()
    parser.add_option("-v", "--verbose", dest="verbose", action="store_true")

    (options, args) = parser.parse_args()

    if options.verbose:
        print_log_to_stdout(log)

    create_current_file_run_log()

    run()
