# -*- encoding: utf-8 -*-
""" Загружает данные о транспортных средствах из файла ./data/vehicles.xml
    и пополняет таблицы:
       www_transportmodel
"""
import travel.avia.admin.init_project  # noqa

import os.path
import sys
import httplib
from datetime import datetime
from xml.etree import ElementTree as ET

from django.conf import settings

from travel.avia.library.python.common.models.geo import Settlement
from travel.avia.library.python.common.lib.mail import mail_process
from travel.avia.library.python.common.utils.safe_xml_parser import get_xml_safe_parser

SoapMessage = """
<SOAP-ENV:Envelope
SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/"
xmlns:SOAP-ENC="http://schemas.xmlsoap.org/soap/encoding/"
xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance"
xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
xmlns:xsd="http://www.w3.org/1999/XMLSchema"
>
<SOAP-ENV:Body>
<ns1:referenceRQ type="cities" xmlns:ns1="http://airmedia.ru/reference/airlines" SOAP-ENC:root="1">
</ns1:referenceRQ>
</SOAP-ENV:Body>
</SOAP-ENV:Envelope>
"""


def run():

    now = datetime.today()
    filename = os.path.join(settings.DATA_PATH, "agent_cities_%s.xml" % now.strftime("%Y-%m-%d"))

    if not os.path.exists(filename):
        webservice = httplib.HTTPConnection("ws.agent.ru")
        webservice.putrequest("POST", "/production/yandex-ws/", True, True)
        webservice.putheader("Host", "ws.agent.ru")
        webservice.putheader("User-Agent", "Python post")
        webservice.putheader("Content-type", "text/xml; charset=\"UTF-8\"")
        webservice.putheader("Content-length", "%d" % len(SoapMessage))
        webservice.putheader("SOAPAction", "\"flightInfoRQ\"")
        webservice.endheaders()
        webservice.send(SoapMessage)

        response = webservice.getresponse()
        if response.status != 200:
            print str(response.status) + ' ' + response.reason
            sys.exit(0)

        f = open(filename, 'w')
        f.write(response.read())
        f.close()

    agent_codes = set()
    tree = ET.parse(filename, parser=get_xml_safe_parser())
    for code in tree.findall('.//{http://airmedia.ru/reference/cities}code'):
        if code.text:
            agent_codes.add(code.text)

    bad_list = []
    for sett in Settlement.objects.all():
        if sett.sirena_id and sett.sirena_id not in agent_codes:
            bad_list.append(sett)

    if bad_list:
        text = u'\n'.join([u'У агентов нет города %s %s с кодом %s' % (sett.id, sett.title, sett.sirena_id)
                           for sett in bad_list])
        mail_process(u"Города которых нет у агентов", text)
    sys.exit(0)


def main():
    run()
