#!/bin/bash

# Запускать от рута!

if [ "`id -u`" != 0 ]; then
    echo Run as root only!
    exit 1
fi

instance_type="$1"

cd "`dirname "$0"`"

log_file="/var/log/yandex-rasp-$instance_type/special/pathfinder/checks.log"

echo -n 'Check pathfinder: ' |& su www-data -c "cat&>> $log_file"
date +"%Y-%m-%d %H:%M:%S" |& su www-data -c "cat&>> $log_file"

/etc/init.d/yandex-rasp-$instance_type-pathfinder check |& su www-data -c "cat&>> $log_file"

res_code="$?"

if [ "$res_code" = '0' ]; then
    echo 'Check was Successful' |& su www-data -c "cat&>> $log_file"
else
    echo 'Check was Failed' |& su www-data -c "cat&>> $log_file"
fi
echo '' |& su www-data -c "cat&>> $log_file"
