# -*- encoding: utf-8 -*-
import travel.avia.admin.init_project  # noqa

import unittest
from cStringIO import StringIO
from datetime import datetime

from django.db.models import Q

from travel.avia.library.python.common.models.geo import Settlement, Station
from travel.avia.library.python.common.lib.mail import mail_tablo_error

_encoding = 'utf8'


def found_city(city):
    return Settlement.objects.filter(Q(title__iexact=city) | Q(title_en__iexact=city)) or \
        Station.objects.filter(Q(t_type__id=2) & (Q(title__iexact=city) | Q(title_en__iexact=city))) or \
        Settlement.objects.filter(synonyms__title=city) or \
        Station.objects.filter(t_type=2, synonyms__title=city)


def enc(data):
    return data.encode(_encoding, 'ignore')


class TestTabloRoutes(unittest.TestCase):
    nose_skip_class = True
    _object_dict = {}

    @classmethod
    def _get_object_dict(cls, model, param, **kwargs):
        key = model.__name__ + '_dict:'.join([key + '=' + repr(value) for key, value in kwargs.iteritems()])
        try:
            return cls._object_dict[key]
        except KeyError:
            try:
                objs = model.objects.filter(**kwargs)
            except AttributeError:
                objs = model.objects.filter(**kwargs)
            cls._object_dict[key] = dict([(getattr(obj, param), obj) for obj in objs])
            return cls._object_dict[key]

    @classmethod
    def get_station_dict(cls, param, **kwargs):
        return cls._get_object_dict(Station, param, **kwargs)

    def shortDescription(self):
        doc = super(TestTabloRoutes, self).shortDescription()
        return doc and enc(doc) or None

    def testTabloRoutes(self):
        u"""Проверяем, что в табло лежат рейсы с существующими в базе городами"""

        from django.db import connection
        cursor = connection.cursor()
        stations = TestTabloRoutes.get_station_dict('id')
        cursor.execute("SELECT r_number, r_title, station_id, arrival, departure"
                       " FROM z_tablo"
                       " WHERE r_title IS NOT NULL"
                       " AND route_id IS NULL"
                       " AND t_type_id = 2"
                       " AND IF(arrival IS NULL, departure, arrival) > %s",
                       [datetime.today()])

        bad_rows = []

        for row in cursor.fetchall():
            r_title = row[1]
            cities = [city.strip() for city in r_title.split(' - ')]

            for city in cities:
                # _default_manager - скрытые города тоже правильные (в данном контексте)
                found = found_city(city)

                if not found:
                    bad_rows.append(row)
                    break

        if bad_rows:
            message = u"Названия городов не совпадают с названиями в базе расписаний:\n"
            format = u'в аэропорте %s неправильный рейс %s: %s; прибытие %s, отправление %s, '
            params = []
            for row in bad_rows:
                number = row[0]
                title = row[1]
                station = stations[row[2]].title
                params.append((station, number, title, row[3], row[4]))
            message += '\n'.join([format % p for p in params])
            self.fail(enc(message))


def main():
    from unittest import TextTestRunner, TestLoader

    text_result = StringIO()
    tests = TestLoader().loadTestsFromTestCase(TestTabloRoutes)
    runner = TextTestRunner(text_result)
    result = runner.run(tests)
    text_result = text_result.getvalue()
    if not result.wasSuccessful():
        mail_tablo_error(u'Tablo test results', text_result)
