# -*- encoding: utf-8 -*-
import travel.avia.admin.init_project  # noqa

import logging
from optparse import OptionParser

from travel.avia.library.python.common.models.schedule import RThread, Route
from travel.avia.admin.lib.logs import print_log_to_stdout, create_current_file_run_log


log = logging.getLogger(__name__)


def _main():
    for thread in RThread.objects.filter(route__hidden=False, route__script_protected=False,
                                         year_days=372 * '0'):
        try:
            route = thread.route
        except Route.DoesNotExist:
            continue

        thread.delete()
        if not route.rthread_set.all():
            route.delete()

    log.info(u'Скрипт успешно отработал')

usage = u"Usage: python %prog [options]"


def main():
    optparser = OptionParser(usage=usage, description=__doc__)
    optparser.add_option('-v', '--verbose', action="store_true",
                         help=u"выводить лог на экран")
    options, args = optparser.parse_args()

    if options.verbose:
        print_log_to_stdout()

    create_current_file_run_log()

    _main()
