# -*- encoding: utf-8 -*-
import travel.avia.admin.init_project  # noqa

import logging
import os.path
from optparse import OptionParser

from django.db import connection, transaction

from travel.avia.admin.lib.logs import create_current_file_run_log, print_log_to_stdout


script_name = os.path.basename(__file__)

log = logging.getLogger(__name__)


@transaction.atomic
def _main():
    cursor = connection.cursor()
    cursor.execute("DELETE FROM www_threadtariff WHERE thread_uid NOT IN (SELECT uid FROM www_rthread);")


usage = u"Usage: python %prog [options]"


def main():
    optparser = OptionParser(usage=usage, description=__doc__)
    optparser.add_option('-v', '--verbose', action="store_true",
                         help=u"выводить лог на экран")
    options, args = optparser.parse_args()

    if options.verbose:
        print_log_to_stdout()

    create_current_file_run_log()

    _main()
