#!/usr/bin/env python
# -*- coding: utf-8 -*-

import subprocess
import sys


def get_yandex_environment_type():
    try:
        with open('/etc/yandex/environment.type') as f:
            return f.read().strip()
    except IOError:
        return 'development'


def main():
    import argparse

    parser = argparse.ArgumentParser()

    parser.add_argument('--env', '-e')
    parser.add_argument('--lock', '-l')
    parser.add_argument('--block', '-b', action='store_true')
    parser.add_argument('command')

    args = parser.parse_args()

    env = get_yandex_environment_type()

    if env == 'stress':
        sys.exit(1)

    if args.env is not None:
        if args.env != env:
            sys.exit(1)

    cmd = ['bash', '-c', args.command]

    if args.lock:
        flock_cmd = ['flock', '--close']

        if not args.block:
            flock_cmd.append('--nonblock')

        flock_cmd.append(args.lock)

        cmd = flock_cmd + cmd

    returncode = subprocess.call(cmd)

    sys.exit(returncode)
