# -*- coding: utf-8 -*-
""" Выгружает список основных ниток, имеющих строки дней курсирования
"""

import travel.avia.admin.init_project  # noqa

import logging
import time
import os.path
import sys
import traceback
import csv
import cStringIO
import codecs

from django.conf import settings
from django.db import connection

from travel.avia.library.python.common.utils.mysql_try_hard import mysql_try_hard
from travel.avia.admin.lib.logs import print_log_to_stdout, create_current_file_run_log
from travel.avia.library.python.common.lib.mail import mail_process


log = logging.getLogger(__name__)


class UnicodeWriter:
    """
    A CSV writer which will write rows to CSV file "f",
    which is encoded in the given encoding.
    """

    def __init__(self, f, dialect=csv.excel, encoding="utf-8", **kwds):
        # Redirect output to a queue
        self.queue = cStringIO.StringIO()
        self.writer = csv.writer(self.queue, dialect=dialect, **kwds)
        self.stream = f
        self.encoder = codecs.getincrementalencoder(encoding)()

    def writerow(self, row):
        self.writer.writerow([unicode(s is None and r'\N' or s).encode("utf-8") for s in row])
        # Fetch UTF-8 output from the queue ...
        data = self.queue.getvalue()
        data = data.decode("utf-8")
        # ... and reencode it into the target encoding
        data = self.encoder.encode(data)
        # write to the target stream
        self.stream.write(data)
        # empty queue
        self.queue.truncate(0)

    def writerows(self, rows):
        for row in rows:
            self.writerow(row)


def run():
    start = time.time()
    log.info(u"Export main threads: start")
    filename = os.path.join(settings.EXPORT_PATH, "export_main_threads.tsv")
    PREFIX = '.in_process'

    log.info(u'File %s', filename)

    @mysql_try_hard
    def get_rows():
        cursor = connection.cursor()
        query = """SELECT uid, template_text FROM www_rthread WHERE template_text != '' ORDER BY uid """
        cursor.execute(query)
        rows = cursor.fetchall()
        cursor.close()
        return rows

    export_file = open(filename + PREFIX, 'w')
    export_writer = UnicodeWriter(export_file, delimiter='\t')
    export_writer.writerows(get_rows())

    os.rename(filename + PREFIX, filename)

    log.info(u"done %f", (time.time() - start))
    log.info(u"Результат доступен по адресу /admin/files/%s", os.path.basename(filename))


def main():
    from optparse import OptionParser

    parser = OptionParser(description=u'Заполнить расписания станций нитками, пересчитанными в локальное время')
    parser.add_option("-v", "--verbose", dest="verbose", action="store_true")

    (options, args) = parser.parse_args()

    if options.verbose:
        print_log_to_stdout()

    create_current_file_run_log()

    message = 'export_main_threads:\n'
    try:
        run()
        message += 'finished successfully'

    except Exception as e:
        message += 'failed\n\n'
        message += str(e)
        message += '\n'.join(traceback.format_exception(*(sys.exc_info())))

    mail_process(u'Main threads export', message)
