# -*- encoding: utf-8 -*-

import travel.avia.admin.init_project  # noqa

import logging
import os.path
from optparse import OptionParser
from xml.etree.ElementTree import iterparse

from django.conf import settings

from travel.avia.library.python.common.utils.safe_xml_parser import get_xml_safe_parser
from travel.avia.library.python.common.models.schedule import TransportType
from travel.avia.library.python.common.models.geo import Station, Country, StationMajority
from travel.avia.admin.importinfo.models.express_2_country_cache import get_country_by_express
from travel.avia.admin.lib.logs import create_current_file_run_log, print_log_to_stdout


log = logging.getLogger(__name__)


majority = StationMajority.objects.get(code='station')


def create_station(express_id, title):
    station = Station(title=title, t_type=TransportType.get_train_type(), majority=majority)
    station.use_direction = "dir"
    try:
        station.country = get_country_by_express(express_id)
    except Country.DoesNotExist:
        pass

    station.save()
    station.set_code('express', express_id)
    log.info(u"Создали станцию %s %s с кодом '%s'",
             station.id, station.title, express_id)
    return station


def process_train(train):
    current_region = None
    need_update_region_list = []
    for station_elem in train.getiterator('station'):
        express_id = station_elem.get('e2code').strip()
        if station_elem.get('e2code').strip() == station_elem.get('name').strip():
            continue
        try:
            station = Station.get_by_code('express', express_id)
        except Station.DoesNotExist:
            station = create_station(express_id, station_elem.get('name'))

        if not station.region:
            need_update_region_list.append(station)
        else:
            if need_update_region_list and current_region == station.region:
                for station in need_update_region_list:
                    station.region = current_region
                    station.save()
                need_update_region_list = []

            if current_region != station.region:
                current_region = station.region
                need_update_region_list = []


def run(log_=None):
    if log_ is not None:
        global log
        log = log_
    middle_stations_file = os.path.join(settings.PROJECT_PATH,
                                        'pathfinder/railway/xml/out.xml')
    for _, elem in iterparse(middle_stations_file, parser=get_xml_safe_parser()):
        if elem.tag == 'train':
            process_train(elem)


def main():
    create_current_file_run_log()

    optparser = OptionParser()
    optparser.add_option('-v', '--verbose', action="store_true",
                         help=u"выводить лог на экран")
    options, args = optparser.parse_args()

    if options.verbose:
        print_log_to_stdout()

    run()
