# -*- coding: utf-8 -*-

import travel.avia.admin.init_project  # noqa

import logging
import time

from travel.avia.library.python.common.utils import maintenance
from travel.avia.admin.lib.logs import create_current_file_run_log, print_log_to_stdout


log = logging.getLogger(__name__)


def run():
    cache_tag = time.strftime('%Y-%m-%d %H:%M:%S')
    log.info(u'Ставим кештег %s', cache_tag)
    maintenance.update_conf({'cache_tag': cache_tag})


def main():
    import argparse

    create_current_file_run_log()

    parser = argparse.ArgumentParser()
    parser.add_argument('-v', '--verbose', action='store_true')

    args = parser.parse_args()
    if args.verbose:
        print_log_to_stdout(log)

    run()
