# -*- coding: utf-8 -*-

import travel.avia.admin.init_project  # noqa

import logging
import re
import os.path
import json
from functools import partial

from django.conf import settings

from travel.avia.library.python.common.lib.mail import mail_message
from travel.avia.library.python.common.utils.http import urlopen
from travel.avia.admin.lib.logs import create_current_file_run_log


send_mail_unknown_codes = partial(mail_message, recipients=settings.UNKNOWN_CODES_RCPNTS)
send_mail_express_subst = partial(mail_message, recipients=settings.EXPERSS_SUBST_RCPNTS)

log = logging.getLogger(__name__)

MAIL_REPORTS_INTERVAL = 600
RE = re.compile(r'(?:DEBUG|ERROR|INFO|WARNING) \d{4}-\d\d-\d\d \d\d:\d\d:\d\d: (.*)')


def preparse_log(log):
    for line in log:
        decoded = line.decode('utf-8')

        m = RE.search(decoded)

        if m:
            yield m.group(1)


def collect_logs(path, n):
    if settings.DEBUG:
        log_path = os.path.join(settings.LOG_PATH, path)

        with open(log_path) as f:
            for line in preparse_log(f):
                yield line

        return

    for host in settings.MORDA_HOSTS:
        url = 'http://rasp.%s/admin/maintenance/logtail/%s?interval=%d' % (
            host, path, n,
            )

        try:
            log.info(u"Качаем урл %s", url)
            response = urlopen(url)

            for line in preparse_log(response):
                yield line

        except Exception, e:
            log.error(u"Ошибка обработки урла %s логов %s", url, unicode(e))
            continue


def mail_unknown_codes():
    log.info(u"Собираем логи для mail_unknown_codes")

    logs = collect_logs('tickets/unknown_codes.log', MAIL_REPORTS_INTERVAL)

    report = create_report(logs)

    if not report:
        log.info(u"Нечего отсылать в mail_unknown_codes")
        return

    subject = u'Неизвестные коды'

    send_mail_unknown_codes(subject, '\n'.join(report))


def create_report(logs):
    class Info(object):
        def __init__(self):
            self.routes = set()
            self.partners = set()
            self.urls = set()

    sections = {}

    for message in logs:
        try:
            desc, code, number, partner, url = json.loads(message)
        except:
            continue

        info = sections.setdefault(desc, {}).setdefault(json.dumps(code), Info())

        info.routes.add(number)
        info.partners.add(partner)

        if url:
            info.urls.add(url)

    report = []

    for desc, codes in sorted(sections.items()):
        report.append(desc.upper())

        for code, info in sorted(codes.items()):
            report.extend([
                '',
                '%s: %s' % (code, ', '.join(map(unicode, info.partners or []))),
                '',
                ', '.join(map(unicode, info.routes or [])),
                '',
            ])

            report.extend(info.urls)

        report.append('')

    if report and report[-1] == '':
        report.pop()

    return report


def mail_express_subst():
    log.info(u"Собираем логи для mail_express_subst")
    substs = {}
    url = None

    for message in collect_logs('tariffs/express_subst.log', MAIL_REPORTS_INTERVAL):
        label, content = message.split(': ', 1)

        if label == u'Ссылка':
            url = content
        else:
            substs[content] = url

    if not substs:
        log.info(u"Нечего отсылать в mail_express_subst")
        return

    report = {}

    for subst, url in substs.items():
        report.setdefault(url, []).append(subst)

    message = []

    for url, substs in report.items():
        substs.sort()

        if url:
            message.extend([url, ''])

        for subst in substs:
            message.append(subst)

        message.append('')

    message.pop()

    subject = u'Неизвестные замены псевдостанций'

    send_mail_express_subst(subject, '\n'.join(message))


def main():
    create_current_file_run_log()

    mail_unknown_codes()
    mail_express_subst()
