# -*- coding: utf-8 -*-
"""
RASPTICKETS-569 - Регионализация запросов к Amargo
"""

import travel.avia.admin.init_project  # noqa

import codecs
from optparse import OptionParser

from travel.avia.library.python.common.models.geo import Settlement, StationCode
from travel.avia.admin.order.models import RegionalizePartnerQueryRule


def _main(filename, error_filename):
    file = codecs.open(filename, encoding='utf8')
    error_file = codecs.open(error_filename, 'wb', 'utf8')

    lines = file.readlines()
    for line in lines[1:]:
        codes = line.split('\t')[1][1:-2]
        iata_from, iata_to = codes.split('-')

        try:
            settlement_from = Settlement.objects.get(iata=iata_from)
        except Settlement.DoesNotExist:
            sc = StationCode.objects.filter(system_id=4, code=iata_from).select_related('station')

            if sc:
                settlement_from = sc[0].station.settlement
            else:
                settlement_from = None

        if not settlement_from:
            error_file.write(iata_from + '\n')

        try:
            settlement_to = Settlement.objects.get(iata=iata_to)
        except Settlement.DoesNotExist:
            sc = StationCode.objects.filter(system_id=4, code=iata_to).select_related('station')

            if sc:
                settlement_to = sc[0].station.settlement
            else:
                settlement_to = None

        if not settlement_to:
            error_file.write(iata_to + '\n')

        if settlement_from and settlement_to:
            rule = RegionalizePartnerQueryRule(
                partner_id=12,
                settlement_from=settlement_from,
                settlement_to=settlement_to
            )
            rule.save()


def main():
    optparser = OptionParser()
    optparser.add_option('-f', '--file', dest='filename', type='string', action='store')
    optparser.add_option('-e', '--error_file', dest='error_filename', type='string', action='store')

    options, args = optparser.parse_args()

    _main(options.filename, options.error_filename)
