import travel.avia.admin.init_project  # noqa

from optparse import OptionParser

from travel.avia.admin.lib.logs import print_log_to_stdout, create_current_file_run_log
from travel.avia.admin.lib.s3sync import s3sync

usage = u'Usage: python %prog [options] [configs]'


def main():
    create_current_file_run_log()

    optparser = OptionParser(usage=usage, description=__doc__)
    optparser.add_option('-v', '--verbose', action='store_true')

    options, configs = optparser.parse_args()

    if options.verbose:
        print_log_to_stdout()
    try:
        for config in configs:
            s3sync(config)
    except:
        pass
