# -*- coding: utf-8 -*-

import travel.avia.admin.init_project  # noqa

import logging
from itertools import chain

from django.db import transaction

from travel.avia.library.python.common.models.geo import Station, Settlement
from travel.avia.library.python.common.models.transport import TransportType
from travel.avia.admin.lib.logs import print_log_to_stdout, create_current_file_run_log


log = logging.getLogger(__name__)


def fill_ttype(ttype):
    ttype_id = ttype.pk

    station_ids = list(Station.objects.filter(rtstation__thread__t_type__id=ttype_id, hidden=False).distinct().values_list('id', flat=True))

    stations = list(Station.objects.filter(id__in=station_ids))

    settlements = Settlement.objects.filter(hidden=False, id__in=list(set(s.settlement_id for s in stations if s.settlement_id)))

    related_settlements = Settlement.objects.filter(station2settlement__station__in=stations, hidden=False)

    for settlement in chain(settlements, related_settlements):
        code = ttype.code == 'suburban' and 'suburban' or ttype.code
        if code not in settlement.type_choices:
            if settlement.type_choices:
                settlement.type_choices = ",".join(settlement.type_choices.split(',') + [code])
            else:
                settlement.type_choices = code
            settlement.save()


@transaction.atomic
def fill_settlement_view_types():
    log.info("Start")
    for ttype in TransportType.objects.all():
        log.info('Transport type "%s"', ttype.code)
        fill_ttype(ttype)
    log.info("Finish")


def main():
    create_current_file_run_log()

    from time import time
    t = time()
    from optparse import OptionParser

    parser = OptionParser()
    parser.add_option("-v", "--verbose", dest="verbose", action="store_true")

    (options, args) = parser.parse_args()

    if options.verbose:
        print_log_to_stdout(log)

    fill_settlement_view_types()
    print time() - t
