# -*- coding: utf-8 -*-

"""
RASPTICKETS-5707
Скопировать медиа—файлы из media/data/partners в media/avia/partners
"""

import travel.avia.admin.init_project  # noqa

import os
import tempfile
import shutil

import logging
import subprocess as sub

from django.conf import settings

log = logging.getLogger(__name__)


def check_call(cmd, *args, **kwargs):
    log.info('cmd: %r %r %r', cmd, args, kwargs)
    sub.check_call(cmd, *args, **kwargs)


def _main(options, args):
    m = settings.MEDIA_ROOT

    check_call(['mkdir', '-p', os.path.join(m, 'avia/partners/dohop/logo/svg')])
    check_call(['mkdir', '-p', os.path.join(m, 'avia/partners/dohop/logo/png')])

    # Copy and rename *.svg
    tmpdir = tempfile.mkdtemp()

    check_call(' '.join(['cp',
                         os.path.join(m, 'data/partners/dohop_svg/*.svg'),
                         tmpdir,
                         ]), shell=True)

    # dohop_{}_{}.svg -> id{}_{}.svg
    check_call(' '.join(['rename', 's/dohop_/id/',
                         os.path.join(tmpdir, 'dohop_*.svg'),
                         ]), shell=True)

    check_call(' '.join(['cp', '--no-clobber',
                         os.path.join(m, tmpdir, 'id*.svg'),
                         os.path.join(m, 'avia/partners/dohop/logo/svg/'),
                         ]), shell=True)

    shutil.rmtree(tmpdir)

    # Copy png
    check_call(' '.join(['cp', '--no-clobber',
                         os.path.join(m, 'data/partners/dohop_svg2png/*.png'),
                         os.path.join(m, 'avia/partners/dohop/logo/png/'),
                         ]), shell=True)


def main():
    from optparse import OptionParser

    optparser = OptionParser()
    optparser.add_option('-v', '--verbose', action='store_true')
    options, args = optparser.parse_args()
    if options.verbose:
        from travel.avia.admin.lib.logs import add_stdout_handler

        add_stdout_handler(log)
    _main(options, args)
