#!/bin/sh

RASP_ENV="development"

if [ $1 ]; then
    RASP_ENV=$1
fi

# Absolute path to this script. /home/user/bin/foo.sh
SCRIPT=$(readlink -f $0)

#  Absolute path this script is in. /home/user/bin
CWD=`dirname $SCRIPT`
DATA_DIR="$CWD/data/partners_response_cache/"

# для production-mode выкачиваем сначала все с кластера
if [ "$RASP_ENV" = "production" ]; then
    CONDUCTOR_URL="http://c.yandex-team.ru/api/groups2hosts/corba_pythonbp?fields=fqdn"
    wget -O - -o /dev/null "$CONDUCTOR_URL" | while read SERVER; do
        rsync -avzL --delay-updates --ignore-existing rsync://$SERVER/rasp-partners-cache $DATA_DIR
    done
fi

cd $DATA_DIR

echo "Creating tarball"
tar -cvvf ../partners_response_cache.tar ./

cd ../

#echo "Removing old files"
#rm -f partners_response_cache/*

echo "Moving tarball to export directory"
mv -f partners_response_cache.tar ../export/

echo "Done. You can download tarball from /admin/files/partners_response_cache.tar"
cd $CWD