# -*- coding: utf-8 -*-

import travel.avia.admin.init_project  # noqa

from www import models
from travel.avia.library.python.common.utils.date import parse_date


def fetch_points(tariffs):
    points = {
        'Station': set(),
        'Settlement': set(),
        }

    for point_from, point_to, date_, tariff in tariffs:
        points[point_from[0]].add(point_from[1])
        points[point_to[0]].add(point_to[1])

    for type_, ids in points.items():
        objects = getattr(models, type_).objects.in_bulk(list(ids))

        points[type_] = objects

    rv = []

    for point_from, point_to, date_, tariff in tariffs:
        point_from = points[point_from[0]].get(point_from[1])
        point_to = points[point_to[0]].get(point_to[1])

        rv.append((point_from, point_to, date_, tariff))

    return rv


def find_min_tariffs(tariffs):
    min_tariffs = {}

    for point_from, point_to, date_, tariff in tariffs:
        settlement_from = point_from.settlement if hasattr(point_from, 'settlement') else point_from
        settlement_to = point_to.settlement if hasattr(point_to, 'settlement') else point_to

        pair = settlement_from, settlement_to

        try:
            min_date, min_tariff = min_tariffs[pair]

            if date_ < min_date or (date_ == min_date and tariff < min_tariff):
                min_tariffs[pair] = date_, tariff
        except KeyError:
            min_tariffs[pair] = date_, tariff

    return min_tariffs


def parse(f):
    tariffs = []

    for line in f:
        pairs = line.split('\t')

        values = {}

        for p in pairs:
            try:
                key, value = p.split('=', 1)
                values[key] = value
            except ValueError:
                pass

        try:
            point_from = values['object_from_type'], int(values['object_from_id'])
            point_to = values['object_to_type'], int(values['object_to_id'])

            tariff = float(values['class_economy_tariff'])

            date_ = parse_date(values['date_forward'])
        except KeyError:
            continue

        tariffs.append((point_from, point_to, date_, tariff))

    tariffs = fetch_points(tariffs)

    min_tariffs = find_min_tariffs(tariffs)

    print min_tariffs


def main():
    import sys

    parse(sys.stdin)
