# -*- coding: utf-8 -*-

"""Для станций ниток самолетов указывает следующий и предыдущий пункты назначения"""

import travel.avia.admin.init_project  # noqa

from itertools import groupby

from django.db import connection, transaction

THREAD_ID = 0
RTSTATION_ID = 1
STATION_ID = 2
STATION_TITLE = 3
SETTLEMENT_TITLE = 4

SELECT_SQL = '''
select rt.thread_id, rt.id, s.id, s.title, st.title

from www_rtstation rt join www_rthread t on rt.thread_id = t.id
    join www_transporttype ttype on t.t_type_id = ttype.id
    join www_station s on rt.station_id = s.id
    left join www_settlement st on s.settlement_id = st.id

where ttype.code = 'plane'
order by rt.thread_id, rt.id
'''

UPDATE_SQL = '''
update www_rtstation set
    next_point = %s,
    prev_point = %s,
    next_station_id = %s,
    prev_station_id = %s
where id = %s
'''


@transaction.atomic
def _main():
    cursor = connection.cursor()
    cursor.execute(SELECT_SQL)
    results = cursor.fetchall()

    def _keyfunc(rt):
        return rt[THREAD_ID]

    for thread, rts in groupby(results, _keyfunc):
        rts = list(rts)
        cnt = len(rts)

        if cnt == 1:
            continue

        for i in xrange(cnt):
            rt = rts[i]

            next_point = None
            prev_point = None
            next_station = None
            prev_station = None

            if i:
                prev_point = point_title(rts[i - 1])
                prev_station = rts[i - 1][STATION_ID]

            if i < cnt - 1:
                next_point = point_title(rts[i + 1])
                next_station = rts[i + 1][STATION_ID]

            cursor.execute(UPDATE_SQL, (next_point, prev_point, next_station, prev_station, rt[RTSTATION_ID]))


def point_title(row):
    return row[SETTLEMENT_TITLE] or row[STATION_TITLE]


def main():
    _main()
