# -*- encoding: utf-8 -*-
import travel.avia.admin.init_project  # noqa

import logging

from django.db import transaction

from travel.avia.admin.order.models import QueryBlackList
from travel.avia.library.python.common.utils import environment
from travel.avia.admin.lib.logs import create_current_file_run_log, print_log_to_stdout

log = logging.getLogger(__name__)


@transaction.atomic
def _main():
    log.info('Update start')

    queryblacklist = QueryBlackList.objects.filter(
        active=True,
        active_to__lt=environment.now().date()
    ).update(active=False)

    log.info('%s rules updated' % queryblacklist)
    log.info('Update done')


def main():
    create_current_file_run_log()

    from optparse import OptionParser

    optparser = OptionParser()
    optparser.add_option('-v', '--verbose', action='store_true')
    optparser.add_option('-m', '--check_maintenance', action='store_true')
    options, args = optparser.parse_args()

    if options.verbose:
        print_log_to_stdout(log)

    try:
        _main()
    except Exception as e:
        log.exception(e)
        raise e
