# -*- coding: utf-8 -*-

from datetime import time, date, datetime

from travel.avia.admin.lib.exceptions import SimpleUnicodeException


class ParseError(SimpleUnicodeException):
    pass


_not_specified = object()


def parse_time(time_str, default=_not_specified, fmt='%H:%M:%S'):
    try:
        if fmt == '%H:%M:%S' or fmt == '%H:%M':
            return time(*map(lambda x: int(x.strip()), time_str.split(':')))
        else:
            return datetime.strptime(time_str, fmt).time()
    except (TypeError, ValueError, AttributeError):
        if default is _not_specified:
            raise ParseError(u"Ошибка разбора времени {}".format(time_str))
        else:
            return default


def parse_date(date_str, default=_not_specified, fmt='%Y-%m-%d'):
    try:
        if fmt == u'%Y-%m-%d':
            return date(*map(int, date_str.split('-')))
        else:
            return datetime.strptime(date_str, fmt).date()
    except (TypeError, ValueError, AttributeError):
        if default is _not_specified:
            raise ParseError(u"Ошибка разбора даты {}".format(date_str))
        else:
            return default


def parse_sql_datetime(dt_str, default=_not_specified):
    format_ = '%Y-%m-%d %H:%M:%S'

    return parse_datetime(dt_str, format_, default)


def parse_xml_datetime(dt_str, default=_not_specified):
    format_ = '%Y-%m-%dT%H:%M:%S'

    return parse_datetime(dt_str, format_, default)


def parse_datetime(dt_str, format_str, default=_not_specified):
    try:
        return datetime.strptime(dt_str, format_str)

    except (ValueError, TypeError):
        if default is _not_specified:
            raise ParseError(u"Ошибка разбора даты и времени {} формат {}".format(dt_str, format_str))

        else:
            return default
