# -*- coding: utf-8 -*-

import logging

from travel.avia.library.python.common.models.schedule import RThread
from travel.avia.library.python.common.utils.progress import PercentageStatus
from travel.avia.admin.lib import tmpfiles
from travel.avia.admin.lib.iterators import chunker
from travel.avia.admin.lib.mysqlutils import MysqlModelUpdater
from travel.avia.admin.lib.schedule import fast_get_route_by_ids_with_threads_and_rtstations


log = logging.getLogger(__name__)


@tmpfiles.clean_temp
def update_import_uids(routes_query):
    log.info(u'Перегенерируем import uid для ниток')

    tmp_dir = tmpfiles.get_tmp_dir()
    with MysqlModelUpdater(RThread, tmp_dir, fields=['import_uid']) as thread_updater:
        route_ids = list(set(routes_query.order_by().values_list('id', flat=True)))
        log.info(u'Всего нужно обработать %s маршрутов', len(route_ids))
        status = PercentageStatus(len(route_ids), log)
        for chunk_route_ids in chunker(route_ids, chunk_size=20000):
            route_by_ids = fast_get_route_by_ids_with_threads_and_rtstations(chunk_route_ids)

            for route in route_by_ids.itervalues():
                status.step()

                for thread in route.threads:
                    thread.gen_import_uid()
                    thread_updater.add(thread)

    log.info(u'Перегенерация успешно закончилась')
