# -*- coding: utf-8 -*-

import travel.avia.admin.init_project  # noqa

from django.db import transaction

from travel.avia.library.python.common.models.schedule import Company
from travel.avia.library.python.common.lib.mail import mail_process


@transaction.atomic
def hide_and_restore_companies():
    hidden_companies = []
    restored_companies = []

    for company in Company.objects.all():
        if company.rthread_set.filter(hidden=False).exists():
            if company.hidden:
                restored_companies.append(company)
                company.hidden = False
                company.save()
        else:
            if not company.hidden:
                hidden_companies.append(company)
                company.hidden = True
                company.save()

    if hidden_companies or restored_companies:
        lines = []

        if hidden_companies:
            lines.append(u'Скрыты перевозчики:')
            lines.extend(hidden_companies)

        if restored_companies:
            if hidden_companies:
                lines.append(u'')

            lines.append(u'Раскрыты перевозчики:')
            lines.extend(restored_companies)

        message = u''.join(u'{}\n'.format(line) for line in lines)

        mail_process(u'Скрытие/раскрытие перевозчиков', message)


def main():
    hide_and_restore_companies()
